/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DynamicFilterId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DynamicFilters {
    private DynamicFilters() {
    }

    public static Expression createDynamicFilterExpression(Metadata metadata, DynamicFilterId id, Type inputType, Expression input, ComparisonExpression.Operator operator) {
        return DynamicFilters.createDynamicFilterExpression(metadata, id, inputType, input, operator, false);
    }

    public static Expression createDynamicFilterExpression(Metadata metadata, DynamicFilterId id, Type inputType, Expression input, ComparisonExpression.Operator operator, boolean nullAllowed) {
        return BuiltinFunctionCallBuilder.resolve(metadata).setName(nullAllowed ? "$internal$dynamic_filter_nullable_function" : "$internal$dynamic_filter_function").addArgument(inputType, input).addArgument(new Constant((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)operator.toString()))).addArgument(new Constant((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)id.toString()))).addArgument((Type)BooleanType.BOOLEAN, (Expression)(nullAllowed ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL)).build();
    }

    @VisibleForTesting
    public static Expression createDynamicFilterExpression(Metadata metadata, DynamicFilterId id, Type inputType, Expression input) {
        return DynamicFilters.createDynamicFilterExpression(metadata, id, inputType, input, ComparisonExpression.Operator.EQUAL);
    }

    public static ExtractResult extractDynamicFilters(Expression expression) {
        List<Expression> conjuncts = IrUtils.extractConjuncts(expression);
        ImmutableList.Builder staticConjuncts = ImmutableList.builder();
        ImmutableList.Builder dynamicConjuncts = ImmutableList.builder();
        for (Expression conjunct : conjuncts) {
            Optional<Descriptor> descriptor = DynamicFilters.getDescriptor(conjunct);
            if (descriptor.isPresent()) {
                dynamicConjuncts.add((Object)descriptor.get());
                continue;
            }
            staticConjuncts.add((Object)conjunct);
        }
        return new ExtractResult((List<Expression>)staticConjuncts.build(), (List<Descriptor>)dynamicConjuncts.build());
    }

    public static Multimap<DynamicFilterId, Descriptor> extractSourceSymbols(List<Descriptor> dynamicFilters) {
        return (Multimap)dynamicFilters.stream().collect(ImmutableListMultimap.toImmutableListMultimap(Descriptor::getId, descriptor -> new Descriptor(descriptor.getId(), DynamicFilters.extractSourceSymbol(descriptor).toSymbolReference(), descriptor.getOperator(), descriptor.isNullAllowed())));
    }

    private static Symbol extractSourceSymbol(Descriptor descriptor) {
        Expression dynamicFilterExpression = descriptor.getInput();
        if (dynamicFilterExpression instanceof SymbolReference) {
            return Symbol.from(dynamicFilterExpression);
        }
        Preconditions.checkState((boolean)(dynamicFilterExpression instanceof Cast));
        Preconditions.checkState((boolean)(((Cast)dynamicFilterExpression).getExpression() instanceof SymbolReference));
        return Symbol.from(((Cast)dynamicFilterExpression).getExpression());
    }

    public static Expression replaceDynamicFilterId(FunctionCall dynamicFilterFunctionCall, DynamicFilterId newId) {
        return new FunctionCall(dynamicFilterFunctionCall.getFunction(), (List<Expression>)ImmutableList.of((Object)dynamicFilterFunctionCall.getArguments().get(0), (Object)dynamicFilterFunctionCall.getArguments().get(1), (Object)new Constant((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)newId.toString())), (Object)dynamicFilterFunctionCall.getArguments().get(3)));
    }

    public static boolean isDynamicFilter(Expression expression) {
        return DynamicFilters.getDescriptor(expression).isPresent();
    }

    public static Optional<Descriptor> getDescriptor(Expression expression) {
        Constant literal;
        Constant literal2;
        Constant literal3;
        if (!(expression instanceof FunctionCall)) {
            return Optional.empty();
        }
        FunctionCall functionCall = (FunctionCall)expression;
        if (!DynamicFilters.isDynamicFilterFunction(functionCall)) {
            return Optional.empty();
        }
        List<Expression> arguments = functionCall.getArguments();
        Preconditions.checkArgument((arguments.size() == 4 ? 1 : 0) != 0, (String)"invalid arguments count: %s", (int)arguments.size());
        Expression probeSymbol = arguments.get(0);
        Expression operatorExpression = arguments.get(1);
        Preconditions.checkArgument((operatorExpression instanceof Constant && (literal3 = (Constant)operatorExpression).getType().equals((Object)VarcharType.VARCHAR) ? 1 : 0) != 0, (String)"operatorExpression is expected to be a varchar: %s", (Object)operatorExpression.getClass().getSimpleName());
        String operatorExpressionString = ((Slice)((Constant)operatorExpression).getValue()).toStringUtf8();
        ComparisonExpression.Operator operator = ComparisonExpression.Operator.valueOf(operatorExpressionString);
        Expression idExpression = arguments.get(2);
        Preconditions.checkArgument((idExpression instanceof Constant && (literal2 = (Constant)idExpression).getType().equals((Object)VarcharType.VARCHAR) ? 1 : 0) != 0, (String)"id is expected to be a varchar: %s", (Object)idExpression.getClass().getSimpleName());
        String id = ((Slice)((Constant)idExpression).getValue()).toStringUtf8();
        Expression nullAllowedExpression = arguments.get(3);
        Preconditions.checkArgument((nullAllowedExpression instanceof Constant && (literal = (Constant)nullAllowedExpression).getType().equals((Object)BooleanType.BOOLEAN) ? 1 : 0) != 0, (String)"nullAllowedExpression is expected to be a boolean constant: %s", (Object)nullAllowedExpression.getClass().getSimpleName());
        boolean nullAllowed = (Boolean)((Constant)nullAllowedExpression).getValue();
        return Optional.of(new Descriptor(new DynamicFilterId(id), probeSymbol, operator, nullAllowed));
    }

    private static boolean isDynamicFilterFunction(FunctionCall functionCall) {
        return DynamicFilters.isDynamicFilterFunction(functionCall.getFunction().getName());
    }

    public static boolean isDynamicFilterFunction(CatalogSchemaFunctionName functionName) {
        return functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("$internal$dynamic_filter_function")) || functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("$internal$dynamic_filter_nullable_function"));
    }

    @ScalarFunction(value="$internal$dynamic_filter_nullable_function", hidden=true)
    public static final class NullableFunction {
        private static final String NAME = "$internal$dynamic_filter_nullable_function";

        private NullableFunction() {
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") Object input, @IsNull boolean inputNull, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") long input, @IsNull boolean inputNull, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") boolean input, @IsNull boolean inputNull, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") double input, @IsNull boolean inputNull, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }
    }

    @ScalarFunction(value="$internal$dynamic_filter_function", hidden=true)
    public static final class Function {
        public static final String NAME = "$internal$dynamic_filter_function";

        private Function() {
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") Object input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") long input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") boolean input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") double input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Descriptor {
        private final DynamicFilterId id;
        private final Expression input;
        private final ComparisonExpression.Operator operator;
        private final boolean nullAllowed;

        public Descriptor(DynamicFilterId id, Expression input, ComparisonExpression.Operator operator, boolean nullAllowed) {
            this.id = Objects.requireNonNull(id, "id is null");
            this.input = Objects.requireNonNull(input, "input is null");
            this.operator = Objects.requireNonNull(operator, "operator is null");
            Preconditions.checkArgument((!nullAllowed || operator == ComparisonExpression.Operator.EQUAL ? 1 : 0) != 0, (Object)"nullAllowed should be true only with EQUAL operator");
            this.nullAllowed = nullAllowed;
        }

        public Descriptor(DynamicFilterId id, Expression input, ComparisonExpression.Operator operator) {
            this(id, input, operator, false);
        }

        public Descriptor(DynamicFilterId id, Expression input) {
            this(id, input, ComparisonExpression.Operator.EQUAL);
        }

        public DynamicFilterId getId() {
            return this.id;
        }

        public Expression getInput() {
            return this.input;
        }

        public ComparisonExpression.Operator getOperator() {
            return this.operator;
        }

        public boolean isNullAllowed() {
            return this.nullAllowed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.input, that.input) && Objects.equals((Object)this.operator, (Object)that.operator) && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.input, this.operator, this.nullAllowed});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("input", (Object)this.input).add("operator", (Object)this.operator).add("nullAllowed", this.nullAllowed).toString();
        }

        public Domain applyComparison(Domain domain) {
            if (domain.isAll()) {
                return domain;
            }
            if (domain.isNone()) {
                if (this.nullAllowed) {
                    return Domain.onlyNull((Type)domain.getType());
                }
                return domain;
            }
            Range span = domain.getValues().getRanges().getSpan();
            switch (this.operator) {
                case EQUAL: {
                    if (this.nullAllowed) {
                        return Domain.create((ValueSet)domain.getValues(), (boolean)true);
                    }
                    return domain;
                }
                case LESS_THAN: {
                    Range range = Range.lessThan((Type)span.getType(), (Object)span.getHighBoundedValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case LESS_THAN_OR_EQUAL: {
                    Range range = Range.lessThanOrEqual((Type)span.getType(), (Object)span.getHighBoundedValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case GREATER_THAN: {
                    Range range = Range.greaterThan((Type)span.getType(), (Object)span.getLowBoundedValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case GREATER_THAN_OR_EQUAL: {
                    Range range = Range.greaterThanOrEqual((Type)span.getType(), (Object)span.getLowBoundedValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
            }
            throw new IllegalArgumentException("Unsupported dynamic filtering comparison operator: " + String.valueOf((Object)this.operator));
        }
    }

    public static class ExtractResult {
        private final List<Expression> staticConjuncts;
        private final List<Descriptor> dynamicConjuncts;

        public ExtractResult(List<Expression> staticConjuncts, List<Descriptor> dynamicConjuncts) {
            this.staticConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(staticConjuncts, "staticConjuncts is null"));
            this.dynamicConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(dynamicConjuncts, "dynamicConjuncts is null"));
        }

        public List<Expression> getStaticConjuncts() {
            return this.staticConjuncts;
        }

        public List<Descriptor> getDynamicConjuncts() {
            return this.dynamicConjuncts;
        }
    }
}

