/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.metadata.ResolvedFunction;
import io.trino.sql.tree.CurrentDate;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentTimestamp;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.LocalTime;
import io.trino.sql.tree.LocalTimestamp;
import io.trino.sql.tree.Node;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public final class DeterminismEvaluator {
    private DeterminismEvaluator() {
    }

    public static boolean isDeterministic(Expression expression, Function<FunctionCall, ResolvedFunction> resolvedFunctionSupplier) {
        Objects.requireNonNull(resolvedFunctionSupplier, "resolvedFunctionSupplier is null");
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean deterministic = new AtomicBoolean(true);
        new Visitor(resolvedFunctionSupplier).process((Node)expression, deterministic);
        return deterministic.get();
    }

    public static boolean containsCurrentTimeFunctions(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean hasTemporalFunction = new AtomicBoolean(false);
        new TemporalFunctionVisitor().process((Node)expression, hasTemporalFunction);
        return hasTemporalFunction.get();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<AtomicBoolean> {
        private final Function<FunctionCall, ResolvedFunction> resolvedFunctionSupplier;

        public Visitor(Function<FunctionCall, ResolvedFunction> resolvedFunctionSupplier) {
            this.resolvedFunctionSupplier = resolvedFunctionSupplier;
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean deterministic) {
            if (!this.resolvedFunctionSupplier.apply(node).isDeterministic()) {
                deterministic.set(false);
                return null;
            }
            return super.visitFunctionCall(node, (Object)deterministic);
        }
    }

    private static class TemporalFunctionVisitor
    extends DefaultExpressionTraversalVisitor<AtomicBoolean> {
        private TemporalFunctionVisitor() {
        }

        protected Void visitCurrentDate(CurrentDate node, AtomicBoolean currentTime) {
            currentTime.set(true);
            return null;
        }

        protected Void visitCurrentTime(CurrentTime node, AtomicBoolean currentTime) {
            currentTime.set(true);
            return null;
        }

        protected Void visitCurrentTimestamp(CurrentTimestamp node, AtomicBoolean currentTime) {
            currentTime.set(true);
            return null;
        }

        protected Void visitLocalTime(LocalTime node, AtomicBoolean currentTime) {
            currentTime.set(true);
            return null;
        }

        protected Void visitLocalTimestamp(LocalTimestamp node, AtomicBoolean currentTime) {
            currentTime.set(true);
            return null;
        }
    }
}

