/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CoalesceCodeGenerator
implements BytecodeGenerator {
    private final Type returnType;
    private final List<RowExpression> arguments;

    public CoalesceCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        this.returnType = specialForm.getType();
        this.arguments = specialForm.getArguments();
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext) {
        ArrayList<BytecodeNode> operands = new ArrayList<BytecodeNode>();
        for (RowExpression expression : this.arguments) {
            operands.add(generatorContext.generate(expression));
        }
        Variable wasNull = generatorContext.wasNull();
        BytecodeBlock nullValue = new BytecodeBlock().append((BytecodeNode)wasNull.set(BytecodeExpressions.constantTrue())).pushJavaDefault(this.returnType.getJavaType());
        for (BytecodeNode operand : operands.reversed()) {
            IfStatement ifStatement = new IfStatement();
            ifStatement.condition().append(operand).append((BytecodeNode)wasNull);
            ifStatement.ifTrue().pop(this.returnType.getJavaType()).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).append((BytecodeNode)nullValue);
            nullValue = ifStatement;
        }
        return nullValue;
    }
}

