/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

@JsonSerialize
public record ArithmeticBinaryExpression(ResolvedFunction function, Operator operator, Expression left, Expression right) implements Expression
{
    public ArithmeticBinaryExpression {
        Objects.requireNonNull(function, "function is null");
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
    }

    @Override
    public Type type() {
        return this.function.getSignature().getReturnType();
    }

    @Deprecated
    public ResolvedFunction getFunction() {
        return this.function;
    }

    @Deprecated
    public Operator getOperator() {
        return this.operator;
    }

    @Deprecated
    public Expression getLeft() {
        return this.left;
    }

    @Deprecated
    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticBinary(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public String toString() {
        return "%s(%s, %s)".formatted(this.operator.getValue(), this.left, this.right);
    }

    public static enum Operator {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        MODULUS("%");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

