/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

@JsonSerialize
public record ArithmeticNegation(Expression value) implements Expression
{
    public ArithmeticNegation {
        Objects.requireNonNull(value, "value is null");
    }

    @Override
    public Type type() {
        return this.value.type();
    }

    @Deprecated
    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticNegation(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public String toString() {
        return "-(%s)".formatted(this.value);
    }
}

