/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

@JsonSerialize
public record BetweenPredicate(Expression value, Expression min, Expression max) implements Expression
{
    @JsonCreator
    public BetweenPredicate {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(min, "min is null");
        Objects.requireNonNull(max, "max is null");
    }

    @Override
    public Type type() {
        return BooleanType.BOOLEAN;
    }

    @Deprecated
    public Expression getValue() {
        return this.value;
    }

    @Deprecated
    public Expression getMin() {
        return this.min;
    }

    @Deprecated
    public Expression getMax() {
        return this.max;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenPredicate(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.value, (Object)this.min, (Object)this.max);
    }

    @Override
    public String toString() {
        return "Between(%s, %s, %s)".formatted(this.value, this.min, this.max);
    }
}

