/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;

@JsonSerialize
public record CoalesceExpression(List<Expression> operands) implements Expression
{
    public CoalesceExpression(Expression first, Expression second, Expression ... additional) {
        this((List<Expression>)ImmutableList.builder().add((Object[])new Expression[]{first, second}).add((Object[])additional).build());
    }

    public CoalesceExpression(List<Expression> operands) {
        Preconditions.checkArgument((operands.size() >= 2 ? 1 : 0) != 0, (Object)"must have at least two operands");
        this.operands = operands = ImmutableList.copyOf(operands);
    }

    @Override
    public Type type() {
        return this.operands.getFirst().type();
    }

    @Deprecated
    public List<Expression> getOperands() {
        return this.operands;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitCoalesceExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return this.operands;
    }
}

