/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BindExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.WhenClause;

public abstract class DefaultTraversalVisitor<C>
extends IrVisitor<Void, C> {
    @Override
    protected Void visitCast(Cast node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected Void visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected Void visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    protected Void visitCoalesceExpression(CoalesceExpression node, C context) {
        for (Expression operand : node.getOperands()) {
            this.process(operand, context);
        }
        return null;
    }

    @Override
    protected Void visitSubscriptExpression(SubscriptExpression node, C context) {
        this.process(node.getBase(), context);
        this.process(node.getIndex(), context);
        return null;
    }

    @Override
    protected Void visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected Void visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        for (Expression argument : node.getValueList()) {
            this.process(argument, context);
        }
        return null;
    }

    @Override
    protected Void visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        return null;
    }

    @Override
    protected Void visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause.getOperand(), context);
            this.process(clause.getResult(), context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Expression)value, context));
        return null;
    }

    @Override
    protected Void visitNullIfExpression(NullIfExpression node, C context) {
        this.process(node.getFirst(), context);
        this.process(node.getSecond(), context);
        return null;
    }

    @Override
    protected Void visitBindExpression(BindExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        this.process(node.getFunction(), context);
        return null;
    }

    @Override
    protected Void visitArithmeticNegation(ArithmeticNegation node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitNotExpression(NotExpression node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause.getOperand(), context);
            this.process(clause.getResult(), context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Expression)value, context));
        return null;
    }

    @Override
    protected Void visitIsNullPredicate(IsNullPredicate node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitLogicalExpression(LogicalExpression node, C context) {
        for (Expression child : node.getTerms()) {
            this.process(child, context);
        }
        return null;
    }

    @Override
    protected Void visitRow(Row node, C context) {
        for (Expression expression : node.getItems()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected Void visitLambdaExpression(LambdaExpression node, C context) {
        this.process(node.getBody(), context);
        return null;
    }
}

