/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BindExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class ExpressionTreeRewriter<C> {
    private final ExpressionRewriter<C> rewriter;
    private final IrVisitor<Expression, Context<C>> visitor;

    public static <T extends Expression> T rewriteWith(ExpressionRewriter<Void> rewriter, T node) {
        return new ExpressionTreeRewriter<Void>(rewriter).rewrite(node, null);
    }

    public static <C, T extends Expression> T rewriteWith(ExpressionRewriter<C> rewriter, T node, C context) {
        return new ExpressionTreeRewriter<C>(rewriter).rewrite(node, context);
    }

    public ExpressionTreeRewriter(ExpressionRewriter<C> rewriter) {
        this.rewriter = rewriter;
        this.visitor = new RewritingVisitor();
    }

    private List<Expression> rewrite(List<Expression> items, Context<C> context) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : items) {
            builder.add((Object)this.rewrite(expression, context.get()));
        }
        return builder.build();
    }

    public <T extends Expression> T rewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context<C>(context, false));
    }

    public <T extends Expression> T defaultRewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context<C>(context, true));
    }

    private static <T> boolean sameElements(Optional<T> a, Optional<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return true;
        }
        if (a.isPresent() != b.isPresent()) {
            return false;
        }
        return a.get() == b.get();
    }

    private static <T> boolean sameElements(Iterable<? extends T> a, Iterable<? extends T> b) {
        if (Iterables.size(a) != Iterables.size(b)) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }

    private class RewritingVisitor
    extends IrVisitor<Expression, Context<C>> {
        private RewritingVisitor() {
        }

        @Override
        protected Expression visitExpression(Expression node, Context<C> context) {
            throw new UnsupportedOperationException("visit() not implemented for " + node.getClass().getName());
        }

        @Override
        protected Expression visitRow(Row node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteRow(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List<Expression> items = ExpressionTreeRewriter.this.rewrite(node.getItems(), context);
            if (!ExpressionTreeRewriter.sameElements(node.getItems(), items)) {
                return new Row(items);
            }
            return node;
        }

        @Override
        protected Expression visitArithmeticNegation(ArithmeticNegation node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticUnary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression child = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (child != node.getValue()) {
                return new ArithmeticNegation(child);
            }
            return node;
        }

        @Override
        public Expression visitArithmeticBinary(ArithmeticBinaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticBinary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ArithmeticBinaryExpression(node.getFunction(), node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitSubscriptExpression(SubscriptExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSubscriptExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression base = ExpressionTreeRewriter.this.rewrite(node.getBase(), context.get());
            Expression index = ExpressionTreeRewriter.this.rewrite(node.getIndex(), context.get());
            if (base != node.getBase() || index != node.getIndex()) {
                return new SubscriptExpression(node.type(), base, index);
            }
            return node;
        }

        @Override
        public Expression visitComparisonExpression(ComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteComparisonExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ComparisonExpression(node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitBetweenPredicate(BetweenPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteBetweenPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression min = ExpressionTreeRewriter.this.rewrite(node.getMin(), context.get());
            Expression max = ExpressionTreeRewriter.this.rewrite(node.getMax(), context.get());
            if (value != node.getValue() || min != node.getMin() || max != node.getMax()) {
                return new BetweenPredicate(value, min, max);
            }
            return node;
        }

        @Override
        public Expression visitLogicalExpression(LogicalExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLogicalExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List<Expression> terms = ExpressionTreeRewriter.this.rewrite(node.getTerms(), context);
            if (!ExpressionTreeRewriter.sameElements(node.getTerms(), terms)) {
                return new LogicalExpression(node.getOperator(), terms);
            }
            return node;
        }

        @Override
        public Expression visitNotExpression(NotExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNotExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new NotExpression(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNullPredicate(IsNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitNullIfExpression(NullIfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNullIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression first = ExpressionTreeRewriter.this.rewrite(node.getFirst(), context.get());
            Expression second = ExpressionTreeRewriter.this.rewrite(node.getSecond(), context.get());
            if (first != node.getFirst() || second != node.getSecond()) {
                return new NullIfExpression(first, second);
            }
            return node;
        }

        @Override
        protected Expression visitSearchedCaseExpression(SearchedCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSearchedCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)this.rewriteWhenClause(expression, context));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (!ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), builder.build())) {
                return new SearchedCaseExpression((List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitSimpleCaseExpression(SimpleCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSimpleCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)this.rewriteWhenClause(expression, context));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (operand != node.getOperand() || !ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), builder.build())) {
                return new SimpleCaseExpression(operand, (List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        protected WhenClause rewriteWhenClause(WhenClause node, Context<C> context) {
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            Expression result = ExpressionTreeRewriter.this.rewrite(node.getResult(), context.get());
            if (operand != node.getOperand() || result != node.getResult()) {
                return new WhenClause(operand, result);
            }
            return node;
        }

        @Override
        protected Expression visitCoalesceExpression(CoalesceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCoalesceExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List<Expression> operands = ExpressionTreeRewriter.this.rewrite(node.getOperands(), context);
            if (!ExpressionTreeRewriter.sameElements(node.getOperands(), operands)) {
                return new CoalesceExpression(operands);
            }
            return node;
        }

        @Override
        public Expression visitFunctionCall(FunctionCall node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFunctionCall(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List<Expression> arguments = ExpressionTreeRewriter.this.rewrite(node.getArguments(), context);
            if (!ExpressionTreeRewriter.sameElements(node.getArguments(), arguments)) {
                return new FunctionCall(node.getFunction(), arguments);
            }
            return node;
        }

        @Override
        protected Expression visitLambdaExpression(LambdaExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLambdaExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression body = ExpressionTreeRewriter.this.rewrite(node.getBody(), context.get());
            if (body != node.getBody()) {
                return new LambdaExpression(node.arguments(), body);
            }
            return node;
        }

        @Override
        protected Expression visitBindExpression(BindExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteBindExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List values = (List)node.getValues().stream().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get())).collect(ImmutableList.toImmutableList());
            Expression function = ExpressionTreeRewriter.this.rewrite(node.getFunction(), context.get());
            if (!ExpressionTreeRewriter.sameElements(values, node.getValues()) || function != node.getFunction()) {
                return new BindExpression(values, (LambdaExpression)function);
            }
            return node;
        }

        @Override
        public Expression visitInPredicate(InPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            List values = (List)node.getValueList().stream().map(entry -> ExpressionTreeRewriter.this.rewrite(entry, context.get())).collect(ImmutableList.toImmutableList());
            if (node.getValue() != value || !ExpressionTreeRewriter.sameElements(values, node.getValueList())) {
                return new InPredicate(value, values);
            }
            return node;
        }

        @Override
        public Expression visitConstant(Constant node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteConstant(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitCast(Cast node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCast(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            if (node.getExpression() != expression) {
                return new Cast(expression, node.getType(), node.isSafe());
            }
            return node;
        }

        @Override
        protected Expression visitSymbolReference(SymbolReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSymbolReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }
    }

    public static class Context<C> {
        private final boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }
}

