/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonSerialize
public record FunctionCall(ResolvedFunction function, List<Expression> arguments) implements Expression
{
    public FunctionCall {
        Objects.requireNonNull(function, "function is null");
        arguments = ImmutableList.copyOf(arguments);
    }

    @Override
    public Type type() {
        return this.function.getSignature().getReturnType();
    }

    @Deprecated
    public ResolvedFunction getFunction() {
        return this.function;
    }

    @Deprecated
    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return "%s(%s)".formatted(this.function.getName(), this.arguments.stream().map((Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/trino/sql/ir/Expression;)Ljava/lang/String;)()).collect(Collectors.joining(", ")));
    }
}

