/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;

@JsonSerialize
public record InPredicate(Expression value, List<Expression> valueList) implements Expression
{
    public InPredicate {
        valueList = ImmutableList.copyOf(valueList);
    }

    @Override
    public Type type() {
        return BooleanType.BOOLEAN;
    }

    @Deprecated
    public Expression getValue() {
        return this.value;
    }

    @Deprecated
    public List<Expression> getValueList() {
        return this.valueList;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitInPredicate(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.builder().add((Object)this.value).addAll(this.valueList).build();
    }
}

