/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import io.trino.metadata.Metadata;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class IrUtils {
    private IrUtils() {
    }

    public static List<Expression> extractConjuncts(Expression expression) {
        return IrUtils.extractPredicates(LogicalExpression.Operator.AND, expression);
    }

    public static List<Expression> extractDisjuncts(Expression expression) {
        return IrUtils.extractPredicates(LogicalExpression.Operator.OR, expression);
    }

    public static List<Expression> extractPredicates(LogicalExpression expression) {
        return IrUtils.extractPredicates(expression.getOperator(), expression);
    }

    public static List<Expression> extractPredicates(LogicalExpression.Operator operator, Expression expression) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        IrUtils.extractPredicates(operator, expression, (ImmutableList.Builder<Expression>)resultBuilder);
        return resultBuilder.build();
    }

    private static void extractPredicates(LogicalExpression.Operator operator, Expression expression, ImmutableList.Builder<Expression> resultBuilder) {
        LogicalExpression logicalExpression;
        if (expression instanceof LogicalExpression && (logicalExpression = (LogicalExpression)expression).getOperator() == operator) {
            for (Expression term : logicalExpression.getTerms()) {
                IrUtils.extractPredicates(operator, term, resultBuilder);
            }
        } else {
            resultBuilder.add((Object)expression);
        }
    }

    public static Expression and(Expression ... expressions) {
        return IrUtils.and(Arrays.asList(expressions));
    }

    public static Expression and(Collection<Expression> expressions) {
        return IrUtils.logicalExpression(LogicalExpression.Operator.AND, expressions);
    }

    public static Expression or(Expression ... expressions) {
        return IrUtils.or(Arrays.asList(expressions));
    }

    public static Expression or(Collection<Expression> expressions) {
        return IrUtils.logicalExpression(LogicalExpression.Operator.OR, expressions);
    }

    public static Expression logicalExpression(LogicalExpression.Operator operator, Collection<Expression> expressions) {
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(expressions, "expressions is null");
        if (expressions.isEmpty()) {
            switch (operator) {
                case AND: {
                    return BooleanLiteral.TRUE_LITERAL;
                }
                case OR: {
                    return BooleanLiteral.FALSE_LITERAL;
                }
            }
            throw new IllegalArgumentException("Unsupported LogicalExpression operator");
        }
        if (expressions.size() == 1) {
            return (Expression)Iterables.getOnlyElement(expressions);
        }
        return new LogicalExpression(operator, (List<Expression>)ImmutableList.copyOf(expressions));
    }

    public static Expression combinePredicates(LogicalExpression.Operator operator, Collection<Expression> expressions) {
        if (operator == LogicalExpression.Operator.AND) {
            return IrUtils.combineConjuncts(expressions);
        }
        return IrUtils.combineDisjuncts(expressions);
    }

    public static Expression combineConjuncts(Expression ... expressions) {
        return IrUtils.combineConjuncts(Arrays.asList(expressions));
    }

    public static Expression combineConjuncts(Collection<Expression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> IrUtils.extractConjuncts(e).stream()).filter(e -> !e.equals(BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        conjuncts = IrUtils.removeDuplicates(conjuncts);
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return IrUtils.and(conjuncts);
    }

    public static Expression combineConjunctsWithDuplicates(Collection<Expression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> IrUtils.extractConjuncts(e).stream()).filter(e -> !e.equals(BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return IrUtils.and(conjuncts);
    }

    public static Expression combineDisjuncts(Expression ... expressions) {
        return IrUtils.combineDisjuncts(Arrays.asList(expressions));
    }

    public static Expression combineDisjuncts(Collection<Expression> expressions) {
        return IrUtils.combineDisjunctsWithDefault(expressions, BooleanLiteral.FALSE_LITERAL);
    }

    public static Expression combineDisjunctsWithDefault(Collection<Expression> expressions, Expression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> disjuncts = expressions.stream().flatMap(e -> IrUtils.extractDisjuncts(e).stream()).filter(e -> !e.equals(BooleanLiteral.FALSE_LITERAL)).collect(Collectors.toList());
        disjuncts = IrUtils.removeDuplicates(disjuncts);
        if (disjuncts.contains(BooleanLiteral.TRUE_LITERAL)) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        return disjuncts.isEmpty() ? emptyDefault : IrUtils.or(disjuncts);
    }

    public static Expression filterDeterministicConjuncts(Metadata metadata, Expression expression) {
        return IrUtils.filterConjuncts(expression, expression1 -> DeterminismEvaluator.isDeterministic(expression1));
    }

    public static Expression filterNonDeterministicConjuncts(Metadata metadata, Expression expression) {
        return IrUtils.filterConjuncts(expression, (Predicate<Expression>)Predicates.not(testExpression -> DeterminismEvaluator.isDeterministic(testExpression)));
    }

    public static Expression filterConjuncts(Expression expression, Predicate<Expression> predicate) {
        List<Expression> conjuncts = IrUtils.extractConjuncts(expression).stream().filter(predicate).collect(Collectors.toList());
        return IrUtils.combineConjuncts(conjuncts);
    }

    @SafeVarargs
    public static Function<Expression, Expression> expressionOrNullSymbols(Predicate<Symbol> ... nullSymbolScopes) {
        return expression -> {
            ImmutableList.Builder resultDisjunct = ImmutableList.builder();
            resultDisjunct.add(expression);
            for (Predicate nullSymbolScope : nullSymbolScopes) {
                List symbols = (List)SymbolsExtractor.extractUnique(expression).stream().filter(nullSymbolScope).collect(ImmutableList.toImmutableList());
                if (symbols.isEmpty()) continue;
                ImmutableList.Builder nullConjuncts = ImmutableList.builder();
                for (Symbol symbol : symbols) {
                    nullConjuncts.add((Object)new IsNullPredicate(symbol.toSymbolReference()));
                }
                resultDisjunct.add((Object)IrUtils.and((Collection<Expression>)nullConjuncts.build()));
            }
            return IrUtils.or((Collection<Expression>)resultDisjunct.build());
        };
    }

    private static List<Expression> removeDuplicates(List<Expression> expressions) {
        HashSet<Expression> seen = new HashSet<Expression>();
        ImmutableList.Builder result = ImmutableList.builder();
        for (Expression expression : expressions) {
            if (!DeterminismEvaluator.isDeterministic(expression)) {
                result.add((Object)expression);
                continue;
            }
            if (seen.contains(expression)) continue;
            result.add((Object)expression);
            seen.add(expression);
        }
        return result.build();
    }

    public static Stream<Expression> preOrder(Expression node) {
        return Streams.stream((Iterable)Traverser.forTree(Expression::getChildren).depthFirstPreOrder((Object)Objects.requireNonNull(node, "node is null")));
    }
}

