/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.planner.Symbol;
import io.trino.type.FunctionType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonSerialize
public record LambdaExpression(List<Symbol> arguments, Expression body) implements Expression
{
    public LambdaExpression {
        Objects.requireNonNull(arguments, "arguments is null");
        Objects.requireNonNull(body, "body is null");
    }

    @Override
    public Type type() {
        return new FunctionType(this.arguments.stream().map(Symbol::getType).collect(Collectors.toList()), this.body.type());
    }

    @Deprecated
    public List<Symbol> getArguments() {
        return this.arguments;
    }

    @Deprecated
    public Expression getBody() {
        return this.body;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitLambdaExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.body);
    }

    @Override
    public String toString() {
        return "(%s) -> %s".formatted(this.arguments.stream().map(Symbol::toString).collect(Collectors.joining(", ")), this.body);
    }
}

