/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

@JsonSerialize
public record NullIfExpression(Expression first, Expression second) implements Expression
{
    public NullIfExpression {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
    }

    @Override
    public Type type() {
        return this.first.type();
    }

    @Deprecated
    public Expression getFirst() {
        return this.first;
    }

    @Deprecated
    public Expression getSecond() {
        return this.second;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitNullIfExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.first, (Object)this.second);
    }

    @Override
    public String toString() {
        return "NullIf(%s, %s)".formatted(this.first, this.second);
    }
}

