/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonSerialize
public record Row(List<Expression> items) implements Expression
{
    public Row(List<Expression> items) {
        Objects.requireNonNull(items, "items is null");
        this.items = items = ImmutableList.copyOf(items);
    }

    @Override
    public Type type() {
        return RowType.anonymous(this.items.stream().map(Expression::type).collect(Collectors.toList()));
    }

    @Deprecated
    public List<Expression> getItems() {
        return this.items;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitRow(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return this.items;
    }
}

