/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.WhenClause;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonSerialize
public record SearchedCaseExpression(List<WhenClause> whenClauses, Optional<Expression> defaultValue) implements Expression
{
    public SearchedCaseExpression {
        whenClauses = ImmutableList.copyOf(whenClauses);
        Objects.requireNonNull(defaultValue, "defaultValue is null");
    }

    @Override
    public Type type() {
        return this.whenClauses.getFirst().getResult().type();
    }

    @Deprecated
    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @Deprecated
    public Optional<Expression> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitSearchedCaseExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.whenClauses.forEach(clause -> {
            builder.add((Object)clause.getOperand());
            builder.add((Object)clause.getResult());
        });
        this.defaultValue.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public String toString() {
        return "SearchedCase(%s, %s)".formatted(this.whenClauses.stream().map(WhenClause::toString).collect(Collectors.joining(", ")), this.defaultValue.map((Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/trino/sql/ir/Expression;)Ljava/lang/String;)()).orElse("null"));
    }
}

