/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonSerialize
public record SimpleCaseExpression(Expression operand, List<WhenClause> whenClauses, Optional<Expression> defaultValue) implements Expression
{
    public SimpleCaseExpression {
        Objects.requireNonNull(operand, "operand is null");
        whenClauses = ImmutableList.copyOf(whenClauses);
        Objects.requireNonNull(defaultValue, "defaultValue is null");
    }

    @Override
    public Type type() {
        return this.whenClauses.getFirst().getResult().type();
    }

    @Deprecated
    public Expression getOperand() {
        return this.operand;
    }

    @Deprecated
    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @Deprecated
    public Optional<Expression> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitSimpleCaseExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)this.operand);
        this.whenClauses.forEach(clause -> {
            builder.add((Object)clause.getOperand());
            builder.add((Object)clause.getResult());
        });
        this.defaultValue.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }
}

