/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.sql.ir.DefaultTraversalVisitor;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DeterminismEvaluator {
    private DeterminismEvaluator() {
    }

    public static boolean isDeterministic(Expression expression) {
        AtomicBoolean deterministic = new AtomicBoolean(true);
        new Visitor().process(expression, deterministic);
        return deterministic.get();
    }

    private static class Visitor
    extends DefaultTraversalVisitor<AtomicBoolean> {
        private Visitor() {
        }

        @Override
        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean deterministic) {
            if (!node.getFunction().isDeterministic()) {
                deterministic.set(false);
                return null;
            }
            return super.visitFunctionCall(node, deterministic);
        }
    }
}

