/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.RelationId;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class GroupingOperationRewriter {
    private GroupingOperationRewriter() {
    }

    public static Expression rewriteGroupingOperation(GroupingOperation expression, Type type, List<Set<Integer>> groupingSets, Map<NodeRef<io.trino.sql.tree.Expression>, ResolvedField> columnReferenceFields, Optional<Symbol> groupIdSymbol, Metadata metadata) {
        Objects.requireNonNull(groupIdSymbol, "groupIdSymbol is null");
        if (groupingSets.size() == 1) {
            Type type2 = type;
            Objects.requireNonNull(type2);
            Type type3 = type2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigintType.class, IntegerType.class}, (Object)type3, n)) {
                case 0 -> {
                    BigintType unused = (BigintType)type3;
                    yield new Constant((Type)BigintType.BIGINT, 0L);
                }
                case 1 -> {
                    IntegerType unused = (IntegerType)type3;
                    yield new Constant((Type)IntegerType.INTEGER, 0L);
                }
                default -> throw new IllegalArgumentException("Unexpected type for GROUPING operation: " + String.valueOf(type));
            };
        }
        Preconditions.checkState((boolean)groupIdSymbol.isPresent(), (Object)"groupId symbol is missing");
        RelationId relationId = columnReferenceFields.get(NodeRef.of((Node)((io.trino.sql.tree.Expression)expression.getGroupingColumns().get(0)))).getFieldId().getRelationId();
        List columns = (List)expression.getGroupingColumns().stream().map(NodeRef::of).peek(groupingColumn -> Preconditions.checkState((boolean)columnReferenceFields.containsKey(groupingColumn), (Object)"the grouping column is not in the columnReferencesField map")).map(columnReferenceFields::get).map(ResolvedField::getFieldId).map(fieldId -> GroupingOperationRewriter.translateFieldToInteger(fieldId, relationId)).collect(ImmutableList.toImmutableList());
        List groupingResults = (List)groupingSets.stream().map(groupingSet -> GroupingOperationRewriter.calculateGrouping(groupingSet, columns)).map(value -> {
            Type type2 = type;
            Objects.requireNonNull(type2);
            Type selector0$temp = type2;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigintType.class, IntegerType.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    BigintType unused = (BigintType)selector0$temp;
                    yield new Constant((Type)BigintType.BIGINT, value);
                }
                case 1 -> {
                    IntegerType unused = (IntegerType)selector0$temp;
                    yield new Constant((Type)IntegerType.INTEGER, value);
                }
                default -> throw new IllegalArgumentException("Unexpected type for GROUPING operation: " + String.valueOf(type));
            };
        }).collect(ImmutableList.toImmutableList());
        return new SubscriptExpression(type, BuiltinFunctionCallBuilder.resolve(metadata).setName("$array").setArguments(Collections.nCopies(groupingResults.size(), type), groupingResults).build(), new ArithmeticBinaryExpression(metadata.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), ArithmeticBinaryExpression.Operator.ADD, groupIdSymbol.get().toSymbolReference(), new Constant((Type)BigintType.BIGINT, 1L)));
    }

    private static int translateFieldToInteger(FieldId fieldId, RelationId requiredOriginRelationId) {
        Preconditions.checkState((boolean)fieldId.getRelationId().equals(requiredOriginRelationId), (Object)"grouping arguments must all come from the same relation");
        return fieldId.getFieldIndex();
    }

    static long calculateGrouping(Set<Integer> groupingSet, List<Integer> columns) {
        long grouping = (1L << columns.size()) - 1L;
        for (int index = 0; index < columns.size(); ++index) {
            int column = columns.get(index);
            if (!groupingSet.contains(column)) continue;
            grouping &= 1L << columns.size() - 1 - index ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return grouping;
    }
}

