/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.scalar.ArraySubscriptOperator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.DynamicFilters;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.gen.VarArgsToMapAdapterGenerator;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BindExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.ResolvedFunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolResolver;
import io.trino.type.FunctionType;
import io.trino.type.TypeCoercion;
import io.trino.util.FastutilSetHelper;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IrExpressionInterpreter {
    private static final CatalogSchemaFunctionName FAIL_NAME = GlobalFunctionCatalog.builtinFunctionName("fail");
    private final Expression expression;
    private final PlannerContext plannerContext;
    private final Metadata metadata;
    private final ConnectorSession connectorSession;
    private final InterpretedFunctionInvoker functionInvoker;
    private final TypeCoercion typeCoercion;
    private final IdentityHashMap<List<Expression>, Set<?>> inListCache = new IdentityHashMap();

    public IrExpressionInterpreter(Expression expression, PlannerContext plannerContext, Session session) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.metadata = plannerContext.getMetadata();
        this.connectorSession = session.toConnectorSession();
        this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
    }

    public static Object evaluateConstantExpression(Expression expression, PlannerContext plannerContext, Session session) {
        return new IrExpressionInterpreter(expression, plannerContext, session).evaluate();
    }

    public Object evaluate() {
        Object result = new Visitor(false).processWithExceptionHandling(this.expression, null);
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public Object evaluate(SymbolResolver inputs) {
        Object result = new Visitor(false).processWithExceptionHandling(this.expression, inputs);
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public Object optimize(SymbolResolver inputs) {
        return new Visitor(true).processWithExceptionHandling(this.expression, inputs);
    }

    private static boolean isArray(Type type) {
        return type instanceof ArrayType;
    }

    private class Visitor
    extends IrVisitor<Object, Object> {
        private final boolean optimize;

        private Visitor(boolean optimize) {
            this.optimize = optimize;
        }

        private Object processWithExceptionHandling(Expression expression, Object context) {
            if (expression == null) {
                return null;
            }
            try {
                return this.process(expression, context);
            }
            catch (TrinoException e) {
                if (this.optimize) {
                    return expression;
                }
                throw e;
            }
        }

        @Override
        protected Object visitSymbolReference(SymbolReference node, Object context) {
            return ((SymbolResolver)context).getValue(Symbol.from(node));
        }

        @Override
        protected Object visitConstant(Constant node, Object context) {
            return node.getValue();
        }

        @Override
        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNullPredicate(this.toExpression(value, node.getValue().type()));
            }
            return value == null;
        }

        @Override
        protected Object visitSearchedCaseExpression(SearchedCaseExpression node, Object context) {
            Object newDefault = null;
            boolean foundNewDefault = false;
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                if (whenOperand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, whenClause.getOperand().type()), this.toExpression(this.processWithExceptionHandling(whenClause.getResult(), context), whenClause.getResult().type())));
                    continue;
                }
                if (!Boolean.TRUE.equals(whenOperand)) continue;
                foundNewDefault = true;
                newDefault = this.processWithExceptionHandling(whenClause.getResult(), context);
                break;
            }
            Object defaultResult = foundNewDefault ? newDefault : this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : this.toExpression(defaultResult, node.type());
            return new SearchedCaseExpression(whenClauses, Optional.ofNullable(defaultExpression));
        }

        @Override
        protected Object visitSimpleCaseExpression(SimpleCaseExpression node, Object context) {
            Object operand = this.processWithExceptionHandling(node.getOperand(), context);
            Type operandType = node.getOperand().type();
            if (operand == null) {
                return this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            }
            Object newDefault = null;
            boolean foundNewDefault = false;
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                if (whenOperand instanceof Expression || operand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, whenClause.getOperand().type()), this.toExpression(this.processWithExceptionHandling(whenClause.getResult(), context), whenClause.getResult().type())));
                    continue;
                }
                if (whenOperand == null || !this.isEqual(operand, operandType, whenOperand, whenClause.getOperand().type())) continue;
                foundNewDefault = true;
                newDefault = this.processWithExceptionHandling(whenClause.getResult(), context);
                break;
            }
            Object defaultResult = foundNewDefault ? newDefault : this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : this.toExpression(defaultResult, node.type());
            return new SimpleCaseExpression(this.toExpression(operand, node.getOperand().type()), whenClauses, Optional.ofNullable(defaultExpression));
        }

        private boolean isEqual(Object operand1, Type type1, Object operand2, Type type2) {
            return Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type1, (Object)type2), (List<Object>)ImmutableList.of((Object)operand1, (Object)operand2)));
        }

        @Override
        protected Object visitCoalesceExpression(CoalesceExpression node, Object context) {
            List<Object> newOperands = this.processOperands(node, context);
            if (newOperands.isEmpty()) {
                return null;
            }
            if (newOperands.size() == 1) {
                return Iterables.getOnlyElement(newOperands);
            }
            return new CoalesceExpression((List)newOperands.stream().map(value -> this.toExpression(value, node.type())).collect(ImmutableList.toImmutableList()));
        }

        private List<Object> processOperands(CoalesceExpression node, Object context) {
            ArrayList<Object> newOperands = new ArrayList<Object>();
            HashSet<Expression> uniqueNewOperands = new HashSet<Expression>();
            for (Expression operand : node.getOperands()) {
                Object value = this.processWithExceptionHandling(operand, context);
                if (value instanceof CoalesceExpression) {
                    for (Expression nestedOperand : ((CoalesceExpression)value).getOperands()) {
                        Constant constant;
                        if (!DeterminismEvaluator.isDeterministic(nestedOperand) || uniqueNewOperands.add(nestedOperand)) {
                            newOperands.add(nestedOperand);
                        }
                        if (!(nestedOperand instanceof Constant) || (constant = (Constant)nestedOperand).getValue() == null) continue;
                        return newOperands;
                    }
                    continue;
                }
                if (value instanceof Expression) {
                    Expression expression = (Expression)value;
                    if (DeterminismEvaluator.isDeterministic(expression) && !uniqueNewOperands.add(expression)) continue;
                    newOperands.add(expression);
                    continue;
                }
                if (value == null) continue;
                newOperands.add(value);
                return newOperands;
            }
            return newOperands;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected Object visitInPredicate(InPredicate node, Object context) {
            block14: {
                block15: {
                    value = this.processWithExceptionHandling(node.getValue(), context);
                    valueList = node.getValueList();
                    if (value == null) {
                        return null;
                    }
                    type = node.getValue().type();
                    if (value instanceof Expression || type instanceof ArrayType || type instanceof MapType || type instanceof RowType) break block14;
                    set = IrExpressionInterpreter.this.inListCache.get(valueList);
                    if (IrExpressionInterpreter.this.inListCache.containsKey(valueList)) break block15;
                    if (!valueList.stream().allMatch((Predicate<Expression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lio/trino/sql/ir/Expression;)Z)(Constant.class))) ** GOTO lbl-1000
                    if (valueList.stream().map((Function<Expression, Constant>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lio/trino/sql/ir/Expression;)Lio/trino/sql/ir/Constant;)(Constant.class)).map((Function<Constant, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Lio/trino/sql/ir/Constant;)Ljava/lang/Object;)()).noneMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isNull(java.lang.Object ), (Ljava/lang/Object;)Z)())) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = nonNullConstants = false;
                    }
                    if (nonNullConstants) {
                        objectSet = valueList.stream().map((Function<Expression, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$visitInPredicate$1(java.lang.Object io.trino.sql.ir.Expression ), (Lio/trino/sql/ir/Expression;)Ljava/lang/Object;)((Visitor)this, (Object)context)).collect(Collectors.toSet());
                        set = FastutilSetHelper.toFastutilHashSet(objectSet, type, IrExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle(), IrExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle());
                    }
                    IrExpressionInterpreter.this.inListCache.put(valueList, set);
                }
                if (set != null) {
                    return set.contains(value);
                }
            }
            hasUnresolvedValue = value instanceof Expression;
            hasNullValue = false;
            found = false;
            values = new ArrayList<Object>(valueList.size());
            types = new ArrayList<Type>(valueList.size());
            equalsOperator = IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.EQUAL, this.types(new Expression[]{node.getValue(), node.getValue()}));
            for (Expression expression : valueList) {
                if (value instanceof Expression && expression instanceof Constant) {
                    values.add(expression);
                    types.add(expression.type());
                    continue;
                }
                inValue = this.process(expression, context);
                if (value instanceof Expression || inValue instanceof Expression) {
                    hasUnresolvedValue = true;
                    values.add(inValue);
                    types.add(expression.type());
                    continue;
                }
                if (inValue == null) {
                    hasNullValue = true;
                    continue;
                }
                result = (Boolean)IrExpressionInterpreter.this.functionInvoker.invoke(equalsOperator, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value, inValue));
                if (result == null) {
                    hasNullValue = true;
                    continue;
                }
                if (found || !result.booleanValue()) continue;
                found = true;
            }
            if (found) {
                return true;
            }
            if (hasUnresolvedValue) {
                expressionValues = this.toExpressions(values, types);
                simplifiedExpressionValues = (List)Stream.concat(expressionValues.stream().filter((Predicate<Expression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$visitInPredicate$2(io.trino.sql.ir.Expression ), (Lio/trino/sql/ir/Expression;)Z)()).distinct(), expressionValues.stream().filter((Predicate<Expression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$visitInPredicate$3(io.trino.sql.ir.Expression ), (Lio/trino/sql/ir/Expression;)Z)())).collect(ImmutableList.toImmutableList());
                if (simplifiedExpressionValues.size() == 1) {
                    return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, this.toExpression(value, type), (Expression)simplifiedExpressionValues.get(0));
                }
                return new InPredicate(this.toExpression(value, type), simplifiedExpressionValues);
            }
            if (hasNullValue) {
                return null;
            }
            return false;
        }

        @Override
        protected Object visitArithmeticNegation(ArithmeticNegation node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                Expression valueExpression = this.toExpression(value, node.getValue().type());
                if (valueExpression instanceof ArithmeticNegation) {
                    ArithmeticNegation argument = (ArithmeticNegation)valueExpression;
                    return argument.getValue();
                }
                return new ArithmeticNegation(valueExpression);
            }
            ResolvedFunction resolvedOperator = IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.NEGATION, this.types(node.getValue()));
            InvocationConvention invocationConvention = new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, true, false);
            MethodHandle handle = IrExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(resolvedOperator, invocationConvention).getMethodHandle();
            if (handle.type().parameterCount() > 0 && handle.type().parameterType(0) == ConnectorSession.class) {
                handle = handle.bindTo(IrExpressionInterpreter.this.connectorSession);
            }
            try {
                return handle.invokeWithArguments(value);
            }
            catch (Throwable throwable) {
                Throwables.throwIfInstanceOf((Throwable)throwable, RuntimeException.class);
                Throwables.throwIfInstanceOf((Throwable)throwable, Error.class);
                throw new RuntimeException(throwable.getMessage(), throwable);
            }
        }

        @Override
        protected Object visitArithmeticBinary(ArithmeticBinaryExpression node, Object context) {
            Object left = this.processWithExceptionHandling(node.getLeft(), context);
            if (left == null) {
                return null;
            }
            Object right = this.processWithExceptionHandling(node.getRight(), context);
            if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ArithmeticBinaryExpression(node.getFunction(), node.getOperator(), this.toExpression(left, node.getLeft().type()), this.toExpression(right, node.getRight().type()));
            }
            return IrExpressionInterpreter.this.functionInvoker.invoke(node.getFunction(), IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        @Override
        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            ComparisonExpression.Operator operator = node.getOperator();
            Expression left = node.getLeft();
            Expression right = node.getRight();
            if (operator == ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                return this.processIsDistinctFrom(context, left, right);
            }
            if (node.getOperator() == ComparisonExpression.Operator.NOT_EQUAL) {
                Object result = this.visitComparisonExpression(this.flipComparison(node), context);
                if (result == null) {
                    return null;
                }
                if (result instanceof ComparisonExpression) {
                    return this.flipComparison((ComparisonExpression)result);
                }
                return (Boolean)result == false;
            }
            if (node.getOperator() == ComparisonExpression.Operator.GREATER_THAN || node.getOperator() == ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL) {
                Object result = this.visitComparisonExpression(this.flipComparison(node), context);
                if (result instanceof ComparisonExpression) {
                    return this.flipComparison((ComparisonExpression)result);
                }
                return result;
            }
            return this.processComparisonExpression(context, operator, left, right);
        }

        private Object processIsDistinctFrom(Object context, Expression leftExpression, Expression rightExpression) {
            Object left = this.processWithExceptionHandling(leftExpression, context);
            Object right = this.processWithExceptionHandling(rightExpression, context);
            if (left == null && right instanceof Expression) {
                return new NotExpression(new IsNullPredicate((Expression)right));
            }
            if (right == null && left instanceof Expression) {
                return new NotExpression(new IsNullPredicate((Expression)left));
            }
            if (left instanceof Expression || right instanceof Expression) {
                return new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, this.toExpression(left, leftExpression.type()), this.toExpression(right, rightExpression.type()));
            }
            return this.invokeOperator(OperatorType.valueOf((String)ComparisonExpression.Operator.IS_DISTINCT_FROM.name()), this.types(leftExpression, rightExpression), Arrays.asList(left, right));
        }

        private Object processComparisonExpression(Object context, ComparisonExpression.Operator operator, Expression leftExpression, Expression rightExpression) {
            Object left = this.processWithExceptionHandling(leftExpression, context);
            if (left == null) {
                return null;
            }
            Object right = this.processWithExceptionHandling(rightExpression, context);
            if (right == null) {
                return null;
            }
            if (left instanceof Expression || right instanceof Expression) {
                return new ComparisonExpression(operator, this.toExpression(left, leftExpression.type()), this.toExpression(right, rightExpression.type()));
            }
            return this.invokeOperator(OperatorType.valueOf((String)operator.name()), this.types(leftExpression, rightExpression), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        private ComparisonExpression flipComparison(ComparisonExpression comparisonExpression) {
            return switch (comparisonExpression.getOperator()) {
                case ComparisonExpression.Operator.EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, comparisonExpression.getLeft(), comparisonExpression.getRight());
                case ComparisonExpression.Operator.NOT_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, comparisonExpression.getLeft(), comparisonExpression.getRight());
                case ComparisonExpression.Operator.LESS_THAN -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, comparisonExpression.getRight(), comparisonExpression.getLeft());
                case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, comparisonExpression.getRight(), comparisonExpression.getLeft());
                case ComparisonExpression.Operator.GREATER_THAN -> new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, comparisonExpression.getRight(), comparisonExpression.getLeft());
                case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, comparisonExpression.getRight(), comparisonExpression.getLeft());
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)comparisonExpression.getOperator()));
            };
        }

        @Override
        protected Object visitBetweenPredicate(BetweenPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            Object min = this.processWithExceptionHandling(node.getMin(), context);
            Object max = this.processWithExceptionHandling(node.getMax(), context);
            if (value instanceof Expression || min instanceof Expression || max instanceof Expression) {
                return new BetweenPredicate(this.toExpression(value, node.getValue().type()), this.toExpression(min, node.getMin().type()), this.toExpression(max, node.getMax().type()));
            }
            Boolean greaterOrEqualToMin = null;
            if (min != null) {
                greaterOrEqualToMin = (Boolean)this.invokeOperator(OperatorType.LESS_THAN_OR_EQUAL, this.types(node.getMin(), node.getValue()), (List<Object>)ImmutableList.of((Object)min, (Object)value));
            }
            Boolean lessThanOrEqualToMax = null;
            if (max != null) {
                lessThanOrEqualToMax = (Boolean)this.invokeOperator(OperatorType.LESS_THAN_OR_EQUAL, this.types(node.getValue(), node.getMax()), (List<Object>)ImmutableList.of((Object)value, (Object)max));
            }
            if (greaterOrEqualToMin == null) {
                return Objects.equals(lessThanOrEqualToMax, Boolean.FALSE) ? Boolean.valueOf(false) : null;
            }
            if (lessThanOrEqualToMax == null) {
                return Objects.equals(greaterOrEqualToMin, Boolean.FALSE) ? Boolean.valueOf(false) : null;
            }
            return greaterOrEqualToMin != false && lessThanOrEqualToMax != false;
        }

        @Override
        protected Object visitNullIfExpression(NullIfExpression node, Object context) {
            Object first = this.processWithExceptionHandling(node.getFirst(), context);
            if (first == null) {
                return null;
            }
            Object second = this.processWithExceptionHandling(node.getSecond(), context);
            if (second == null) {
                return first;
            }
            Type firstType = node.getFirst().type();
            Type secondType = node.getSecond().type();
            if (this.hasUnresolvedValue(first, second)) {
                return new NullIfExpression(this.toExpression(first, firstType), this.toExpression(second, secondType));
            }
            Type commonType = IrExpressionInterpreter.this.typeCoercion.getCommonSuperType(firstType, secondType).get();
            ResolvedFunction firstCast = IrExpressionInterpreter.this.metadata.getCoercion(firstType, commonType);
            ResolvedFunction secondCast = IrExpressionInterpreter.this.metadata.getCoercion(secondType, commonType);
            boolean equal = Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType), (List<Object>)ImmutableList.of((Object)IrExpressionInterpreter.this.functionInvoker.invoke(firstCast, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)first)), (Object)IrExpressionInterpreter.this.functionInvoker.invoke(secondCast, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)second)))));
            if (equal) {
                return null;
            }
            return first;
        }

        @Override
        protected Object visitNotExpression(NotExpression node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new NotExpression(this.toExpression(value, node.getValue().type()));
            }
            return (Boolean)value == false;
        }

        @Override
        protected Object visitLogicalExpression(LogicalExpression node, Object context) {
            ArrayList<Object> terms = new ArrayList<Object>();
            ArrayList<Type> types = new ArrayList<Type>();
            for (Expression term : node.getTerms()) {
                Object processed = this.processWithExceptionHandling(term, context);
                switch (node.getOperator()) {
                    case AND: {
                        if (Boolean.FALSE.equals(processed)) {
                            return false;
                        }
                        if (Boolean.TRUE.equals(processed)) break;
                        terms.add(processed);
                        types.add(term.type());
                        break;
                    }
                    case OR: {
                        if (Boolean.TRUE.equals(processed)) {
                            return true;
                        }
                        if (Boolean.FALSE.equals(processed)) break;
                        terms.add(processed);
                        types.add(term.type());
                    }
                }
            }
            if (terms.isEmpty()) {
                return switch (node.getOperator()) {
                    default -> throw new MatchException(null, null);
                    case LogicalExpression.Operator.AND -> true;
                    case LogicalExpression.Operator.OR -> false;
                };
            }
            if (terms.size() == 1) {
                return terms.get(0);
            }
            if (terms.stream().allMatch(Objects::isNull)) {
                return null;
            }
            ImmutableList.Builder expressions = ImmutableList.builder();
            for (int i = 0; i < terms.size(); ++i) {
                expressions.add((Object)this.toExpression(terms.get(i), (Type)types.get(i)));
            }
            return new LogicalExpression(node.getOperator(), (List<Expression>)expressions.build());
        }

        @Override
        protected Object visitFunctionCall(FunctionCall node, Object context) {
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (Expression expression : node.getArguments()) {
                Object value = this.processWithExceptionHandling(expression, context);
                Type type = expression.type();
                argumentValues.add(value);
                argumentTypes.add(type);
            }
            ResolvedFunction resolvedFunction = node.getFunction();
            FunctionNullability functionNullability = resolvedFunction.getFunctionNullability();
            for (int i = 0; i < argumentValues.size(); ++i) {
                Object value = argumentValues.get(i);
                if (value != null || functionNullability.isArgumentNullable(i)) continue;
                return null;
            }
            if (this.optimize && (!resolvedFunction.isDeterministic() || this.hasUnresolvedValue(argumentValues) || DynamicFilters.isDynamicFilter(node) || resolvedFunction.getSignature().getName().equals((Object)FAIL_NAME))) {
                return ResolvedFunctionCallBuilder.builder(resolvedFunction).setArguments(this.toExpressions(argumentValues, argumentTypes)).build();
            }
            return IrExpressionInterpreter.this.functionInvoker.invoke(resolvedFunction, IrExpressionInterpreter.this.connectorSession, argumentValues);
        }

        @Override
        protected Object visitLambdaExpression(LambdaExpression node, Object context) {
            if (this.optimize) {
                Expression optimizedBody;
                Object value = this.processWithExceptionHandling(node.getBody(), context);
                if (value instanceof Expression) {
                    optimizedBody = (Expression)value;
                } else {
                    Type type = node.getBody().type();
                    optimizedBody = this.toExpression(value, type);
                }
                return new LambdaExpression(node.getArguments(), optimizedBody);
            }
            Expression body = node.getBody();
            List<String> argumentNames = node.getArguments().stream().map(Symbol::getName).toList();
            FunctionType functionType = (FunctionType)node.type();
            Preconditions.checkArgument((argumentNames.size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
            return VarArgsToMapAdapterGenerator.generateVarArgsToMapAdapter(Primitives.wrap((Class)functionType.getReturnType().getJavaType()), (List)functionType.getArgumentTypes().stream().map(Type::getJavaType).map(Primitives::wrap).collect(ImmutableList.toImmutableList()), argumentNames, map -> this.processWithExceptionHandling(body, new LambdaSymbolResolver((Map<String, Object>)map)));
        }

        @Override
        protected Object visitBindExpression(BindExpression node, Object context) {
            List<Object> values = node.getValues().stream().map(value -> this.processWithExceptionHandling((Expression)value, context)).collect(Collectors.toList());
            Object function = this.processWithExceptionHandling(node.getFunction(), context);
            if (this.hasUnresolvedValue(values) || this.hasUnresolvedValue(function)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < values.size(); ++i) {
                    builder.add((Object)this.toExpression(values.get(i), node.getValues().get(i).type()));
                }
                return new BindExpression((List<Expression>)builder.build(), (LambdaExpression)function);
            }
            return MethodHandles.insertArguments((MethodHandle)function, 0, values.toArray());
        }

        @Override
        public Object visitCast(Cast node, Object context) {
            Object value = this.processWithExceptionHandling(node.getExpression(), context);
            Type targetType = node.getType();
            Type sourceType = node.getExpression().type();
            if (value instanceof Expression) {
                if (targetType.equals((Object)sourceType)) {
                    return value;
                }
                return new Cast((Expression)value, node.getType(), node.isSafe());
            }
            if (value == null) {
                return null;
            }
            ResolvedFunction operator = IrExpressionInterpreter.this.metadata.getCoercion(sourceType, targetType);
            try {
                return IrExpressionInterpreter.this.functionInvoker.invoke(operator, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value));
            }
            catch (RuntimeException e) {
                if (node.isSafe()) {
                    return null;
                }
                throw e;
            }
        }

        @Override
        protected Object visitRow(Row node, Object context) {
            RowType rowType = (RowType)node.type();
            List parameterTypes = rowType.getTypeParameters();
            List<Expression> arguments = node.getItems();
            int cardinality = arguments.size();
            ArrayList<Object> values = new ArrayList<Object>(cardinality);
            for (Expression argument : arguments) {
                values.add(this.processWithExceptionHandling(argument, context));
            }
            if (this.hasUnresolvedValue(values)) {
                return new Row(this.toExpressions(values, parameterTypes));
            }
            return RowValueBuilder.buildRowValue((RowType)rowType, fields -> {
                for (int i = 0; i < cardinality; ++i) {
                    TypeUtils.writeNativeValue((Type)((Type)parameterTypes.get(i)), (BlockBuilder)((BlockBuilder)fields.get(i)), values.get(i));
                }
            });
        }

        @Override
        protected Object visitSubscriptExpression(SubscriptExpression node, Object context) {
            Object base = this.processWithExceptionHandling(node.getBase(), context);
            if (base == null) {
                return null;
            }
            Object index = this.processWithExceptionHandling(node.getIndex(), context);
            if (index == null) {
                return null;
            }
            if (index instanceof Long && IrExpressionInterpreter.isArray(node.getBase().type())) {
                ArraySubscriptOperator.checkArrayIndex((Long)index);
            }
            if (this.hasUnresolvedValue(base, index)) {
                return new SubscriptExpression(node.type(), this.toExpression(base, node.getBase().type()), this.toExpression(index, node.getIndex().type()));
            }
            if (base instanceof SqlRow) {
                SqlRow row = (SqlRow)base;
                int fieldIndex = Math.toIntExact((Long)index - 1L);
                if (fieldIndex < 0 || fieldIndex >= row.getFieldCount()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "ROW index out of bounds: " + (fieldIndex + 1));
                }
                Type returnType = (Type)node.getBase().type().getTypeParameters().get(fieldIndex);
                return TypeUtils.readNativeValue((Type)returnType, (Block)row.getRawFieldBlock(fieldIndex), (int)row.getRawIndex());
            }
            return this.invokeOperator(OperatorType.SUBSCRIPT, this.types(node.getBase(), node.getIndex()), (List<Object>)ImmutableList.of((Object)base, (Object)index));
        }

        @Override
        protected Object visitExpression(Expression node, Object context) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "not yet implemented: " + node.getClass().getName());
        }

        private List<Type> types(Expression ... expressions) {
            return (List)Stream.of(expressions).map(Expression::type).collect(ImmutableList.toImmutableList());
        }

        private boolean hasUnresolvedValue(Object ... values) {
            return this.hasUnresolvedValue((List<Object>)ImmutableList.copyOf((Object[])values));
        }

        private boolean hasUnresolvedValue(List<Object> values) {
            return values.stream().anyMatch(Predicates.instanceOf(Expression.class));
        }

        private Object invokeOperator(OperatorType operatorType, List<? extends Type> argumentTypes, List<Object> argumentValues) {
            ResolvedFunction operator = IrExpressionInterpreter.this.metadata.resolveOperator(operatorType, argumentTypes);
            return IrExpressionInterpreter.this.functionInvoker.invoke(operator, IrExpressionInterpreter.this.connectorSession, argumentValues);
        }

        private Expression toExpression(Object base, Type type) {
            if (base instanceof Expression) {
                Expression expression = (Expression)base;
                return expression;
            }
            return new Constant(type, base);
        }

        private List<Expression> toExpressions(List<Object> values, List<Type> types) {
            Preconditions.checkArgument((values.size() == types.size() ? 1 : 0) != 0, (Object)"values and types do not have the same size");
            ImmutableList.Builder expressions = ImmutableList.builder();
            for (int i = 0; i < values.size(); ++i) {
                Expression expression;
                Object object = values.get(i);
                if (object instanceof Expression) {
                    Expression expression2 = (Expression)object;
                    expression = expression2;
                } else {
                    expression = new Constant(types.get(i), object);
                }
                expressions.add((Object)expression);
            }
            return expressions.build();
        }

        private static /* synthetic */ boolean lambda$visitInPredicate$3(Expression expression) {
            return !DeterminismEvaluator.isDeterministic(expression);
        }

        private static /* synthetic */ boolean lambda$visitInPredicate$2(Expression expression) {
            return DeterminismEvaluator.isDeterministic(expression);
        }

        private /* synthetic */ Object lambda$visitInPredicate$1(Object context, Expression expression) {
            return this.processWithExceptionHandling(expression, context);
        }
    }

    private static class LambdaSymbolResolver
    implements SymbolResolver {
        private final Map<String, Object> values;

        public LambdaSymbolResolver(Map<String, Object> values) {
            this.values = Objects.requireNonNull(values, "values is null");
        }

        @Override
        public Object getValue(Symbol symbol) {
            Preconditions.checkState((boolean)this.values.containsKey(symbol.getName()), (String)"values does not contain %s", (Object)symbol);
            return this.values.get(symbol.getName());
        }
    }
}

