/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.DefaultTraversalVisitor;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SubscriptExpression;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NullabilityAnalyzer {
    private NullabilityAnalyzer() {
    }

    public static boolean mayReturnNullOnNonNullInput(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean result = new AtomicBoolean(false);
        new Visitor().process(expression, result);
        return result.get();
    }

    private static class Visitor
    extends DefaultTraversalVisitor<AtomicBoolean> {
        private Visitor() {
        }

        @Override
        protected Void visitCast(Cast node, AtomicBoolean result) {
            this.process(node.getExpression(), result);
            result.compareAndSet(false, node.isSafe());
            return null;
        }

        @Override
        protected Void visitNullIfExpression(NullIfExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitInPredicate(InPredicate node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitSearchedCaseExpression(SearchedCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitSimpleCaseExpression(SimpleCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitSubscriptExpression(SubscriptExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitConstant(Constant node, AtomicBoolean result) {
            if (node.getValue() == null) {
                result.set(true);
            }
            return null;
        }
    }
}

