/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.NodeRef;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class PartialTranslator {
    private PartialTranslator() {
    }

    public static Map<NodeRef<Expression>, ConnectorExpression> extractPartialTranslations(Expression inputExpression, Session session) {
        Objects.requireNonNull(inputExpression, "inputExpression is null");
        Objects.requireNonNull(session, "session is null");
        HashMap<NodeRef<Expression>, ConnectorExpression> partialTranslations = new HashMap<NodeRef<Expression>, ConnectorExpression>();
        new Visitor(session, partialTranslations).process(inputExpression);
        return ImmutableMap.copyOf(partialTranslations);
    }

    private static class Visitor
    extends IrVisitor<Void, Void> {
        private final Map<NodeRef<Expression>, ConnectorExpression> translatedSubExpressions;
        private final ConnectorExpressionTranslator.SqlToConnectorExpressionTranslator translator;

        Visitor(Session session, Map<NodeRef<Expression>, ConnectorExpression> translatedSubExpressions) {
            this.translatedSubExpressions = Objects.requireNonNull(translatedSubExpressions, "translatedSubExpressions is null");
            this.translator = new ConnectorExpressionTranslator.SqlToConnectorExpressionTranslator(session);
        }

        @Override
        public Void visitExpression(Expression node, Void context) {
            Optional result = (Optional)this.translator.process(node);
            if (result.isPresent()) {
                this.translatedSubExpressions.put(NodeRef.of(node), (ConnectorExpression)result.get());
            } else {
                node.getChildren().forEach(this::process);
            }
            return null;
        }

        @Override
        public Void visitLambdaExpression(LambdaExpression functionCall, Void context) {
            return null;
        }
    }
}

