/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.metadata.ResolvedFunction;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResolvedFunctionCallBuilder {
    private final ResolvedFunction resolvedFunction;
    private List<Expression> argumentValues = new ArrayList<Expression>();

    public static ResolvedFunctionCallBuilder builder(ResolvedFunction resolvedFunction) {
        return new ResolvedFunctionCallBuilder(resolvedFunction);
    }

    private ResolvedFunctionCallBuilder(ResolvedFunction resolvedFunction) {
        this.resolvedFunction = Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
    }

    public ResolvedFunctionCallBuilder addArgument(Expression value) {
        Objects.requireNonNull(value, "value is null");
        this.argumentValues.add(value);
        return this;
    }

    public ResolvedFunctionCallBuilder setArguments(List<Expression> values) {
        Objects.requireNonNull(values, "values is null");
        this.argumentValues = new ArrayList<Expression>(values);
        return this;
    }

    public FunctionCall build() {
        return new FunctionCall(this.resolvedFunction, this.argumentValues);
    }
}

