/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.SymbolKeySerializer;
import java.util.Objects;

@JsonSerialize(keyUsing=SymbolKeySerializer.class)
public class Symbol
implements Comparable<Symbol> {
    private final String name;
    private final Type type;

    public static Symbol from(Expression expression) {
        if (!(expression instanceof SymbolReference)) {
            throw new IllegalArgumentException("Unexpected expression: " + String.valueOf(expression));
        }
        SymbolReference symbol = (SymbolReference)expression;
        return new Symbol(symbol.type(), symbol.name());
    }

    @JsonCreator
    public Symbol(Type type, String name) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        this.type = type;
        this.name = name;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    public SymbolReference toSymbolReference() {
        return new SymbolReference(this.type, this.name);
    }

    public String toString() {
        return this.name + "::[" + String.valueOf(this.type) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return this.name.equals(symbol.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Symbol o) {
        return this.name.compareTo(o.name);
    }
}

