/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.json.ir.IrJsonPath;
import io.trino.metadata.ResolvedFunction;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.JsonPathTranslator;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.Symbol;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentDate;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentTimestamp;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.LocalTime;
import io.trino.sql.tree.LocalTimestamp;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TryExpression;
import io.trino.type.FunctionType;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.JsonType;
import io.trino.type.LikePatternType;
import io.trino.type.UnknownType;
import io.trino.util.DateTimeUtils;
import io.trino.util.Failures;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TranslationMap {
    private final Scope scope;
    private final Analysis analysis;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments;
    private final Optional<TranslationMap> outerContext;
    private final Session session;
    private final PlannerContext plannerContext;
    private final Symbol[] fieldSymbols;
    private final Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> astToSymbols;
    private final Map<NodeRef<io.trino.sql.tree.Expression>, Symbol> substitutions;

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, List<Symbol> fieldSymbols, Session session, PlannerContext plannerContext) {
        this(outerContext, scope, analysis, lambdaArguments, (Symbol[])fieldSymbols.toArray(new Symbol[0]).clone(), (Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of(), (Map<NodeRef<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of(), session, plannerContext);
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, List<Symbol> fieldSymbols, Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> astToSymbols, Session session, PlannerContext plannerContext) {
        this(outerContext, scope, analysis, lambdaArguments, fieldSymbols.toArray(new Symbol[0]), astToSymbols, (Map<NodeRef<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of(), session, plannerContext);
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, Symbol[] fieldSymbols, Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> astToSymbols, Map<NodeRef<io.trino.sql.tree.Expression>, Symbol> substitutions, Session session, PlannerContext plannerContext) {
        this.outerContext = Objects.requireNonNull(outerContext, "outerContext is null");
        this.scope = Objects.requireNonNull(scope, "scope is null");
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.lambdaArguments = Objects.requireNonNull(lambdaArguments, "lambdaArguments is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.substitutions = ImmutableMap.copyOf(substitutions);
        Objects.requireNonNull(fieldSymbols, "fieldSymbols is null");
        this.fieldSymbols = (Symbol[])fieldSymbols.clone();
        Objects.requireNonNull(astToSymbols, "astToSymbols is null");
        this.astToSymbols = ImmutableMap.copyOf(astToSymbols);
        Preconditions.checkArgument((scope.getLocalScopeFieldCount() == fieldSymbols.length ? 1 : 0) != 0, (String)"scope: %s, fields mappings: %s", (int)scope.getRelationType().getAllFieldCount(), (int)fieldSymbols.length);
    }

    public TranslationMap withScope(Scope scope, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, scope, this.analysis, this.lambdaArguments, fields.toArray(new Symbol[0]), this.astToSymbols, this.substitutions, this.session, this.plannerContext);
    }

    public TranslationMap withNewMappings(Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> mappings, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, fields, mappings, this.session, this.plannerContext);
    }

    public TranslationMap withAdditionalMappings(Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> mappings) {
        HashMap<ScopeAware<io.trino.sql.tree.Expression>, Symbol> newMappings = new HashMap<ScopeAware<io.trino.sql.tree.Expression>, Symbol>();
        newMappings.putAll(this.astToSymbols);
        newMappings.putAll(mappings);
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, this.fieldSymbols, newMappings, this.substitutions, this.session, this.plannerContext);
    }

    public TranslationMap withAdditionalIdentityMappings(Map<NodeRef<io.trino.sql.tree.Expression>, Symbol> mappings) {
        HashMap<NodeRef<io.trino.sql.tree.Expression>, Symbol> newMappings = new HashMap<NodeRef<io.trino.sql.tree.Expression>, Symbol>();
        newMappings.putAll(this.substitutions);
        newMappings.putAll(mappings);
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, this.fieldSymbols, this.astToSymbols, newMappings, this.session, this.plannerContext);
    }

    public List<Symbol> getFieldSymbols() {
        return Collections.unmodifiableList(Arrays.asList(this.fieldSymbols));
    }

    public Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> getMappings() {
        return this.astToSymbols;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public boolean canTranslate(io.trino.sql.tree.Expression expression) {
        if (this.astToSymbols.containsKey(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope)) || this.substitutions.containsKey(NodeRef.of((Node)expression)) || expression instanceof FieldReference) {
            return true;
        }
        if (this.analysis.isColumnReference(expression)) {
            ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)expression));
            return this.scope.isLocalScope(field.getScope());
        }
        return false;
    }

    public Expression rewrite(io.trino.sql.tree.Expression root) {
        Verify.verify((boolean)this.analysis.isAnalyzed(root), (String)"Expression is not analyzed (%s): %s", (Object)root.getClass().getName(), (Object)root);
        return this.translate(root, true);
    }

    private Expression translateExpression(io.trino.sql.tree.Expression expression) {
        return this.translate(expression, false);
    }

    private Expression translate(io.trino.sql.tree.Expression expr, boolean isRoot) {
        Expression result;
        Optional<SymbolReference> mapped = this.tryGetMapping(expr);
        if (mapped.isPresent()) {
            result = mapped.get();
        } else {
            io.trino.sql.tree.Expression expression = expr;
            Objects.requireNonNull(expression);
            io.trino.sql.tree.Expression expression2 = expression;
            int n = 0;
            result = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FieldReference.class, Identifier.class, io.trino.sql.tree.FunctionCall.class, DereferenceExpression.class, Array.class, CurrentCatalog.class, CurrentSchema.class, CurrentPath.class, CurrentUser.class, CurrentDate.class, CurrentTime.class, CurrentTimestamp.class, LocalTime.class, LocalTimestamp.class, Extract.class, AtTimeZone.class, Format.class, TryExpression.class, LikePredicate.class, Trim.class, SubscriptExpression.class, LambdaExpression.class, Parameter.class, JsonExists.class, JsonValue.class, JsonQuery.class, JsonObject.class, JsonArray.class, LongLiteral.class, DoubleLiteral.class, StringLiteral.class, io.trino.sql.tree.BooleanLiteral.class, DecimalLiteral.class, GenericLiteral.class, BinaryLiteral.class, IntervalLiteral.class, io.trino.sql.tree.ArithmeticBinaryExpression.class, ArithmeticUnaryExpression.class, ComparisonExpression.class, io.trino.sql.tree.Cast.class, io.trino.sql.tree.Row.class, NotExpression.class, io.trino.sql.tree.LogicalExpression.class, NullLiteral.class, CoalesceExpression.class, io.trino.sql.tree.IsNullPredicate.class, IsNotNullPredicate.class, io.trino.sql.tree.BetweenPredicate.class, IfExpression.class, InPredicate.class, io.trino.sql.tree.SimpleCaseExpression.class, io.trino.sql.tree.SearchedCaseExpression.class, NullIfExpression.class}, (Object)expression2, n)) {
                case 0 -> {
                    FieldReference expression = (FieldReference)expression2;
                    yield this.translate(expression);
                }
                case 1 -> {
                    Identifier expression = (Identifier)expression2;
                    yield this.translate(expression);
                }
                case 2 -> {
                    io.trino.sql.tree.FunctionCall expression = (io.trino.sql.tree.FunctionCall)expression2;
                    yield this.translate(expression);
                }
                case 3 -> {
                    DereferenceExpression expression = (DereferenceExpression)expression2;
                    yield this.translate(expression);
                }
                case 4 -> {
                    Array expression = (Array)expression2;
                    yield this.translate(expression);
                }
                case 5 -> {
                    CurrentCatalog expression = (CurrentCatalog)expression2;
                    yield this.translate(expression);
                }
                case 6 -> {
                    CurrentSchema expression = (CurrentSchema)expression2;
                    yield this.translate(expression);
                }
                case 7 -> {
                    CurrentPath expression = (CurrentPath)expression2;
                    yield this.translate(expression);
                }
                case 8 -> {
                    CurrentUser expression = (CurrentUser)expression2;
                    yield this.translate(expression);
                }
                case 9 -> {
                    CurrentDate expression = (CurrentDate)expression2;
                    yield this.translate(expression);
                }
                case 10 -> {
                    CurrentTime expression = (CurrentTime)expression2;
                    yield this.translate(expression);
                }
                case 11 -> {
                    CurrentTimestamp expression = (CurrentTimestamp)expression2;
                    yield this.translate(expression);
                }
                case 12 -> {
                    LocalTime expression = (LocalTime)expression2;
                    yield this.translate(expression);
                }
                case 13 -> {
                    LocalTimestamp expression = (LocalTimestamp)expression2;
                    yield this.translate(expression);
                }
                case 14 -> {
                    Extract expression = (Extract)expression2;
                    yield this.translate(expression);
                }
                case 15 -> {
                    AtTimeZone expression = (AtTimeZone)expression2;
                    yield this.translate(expression);
                }
                case 16 -> {
                    Format expression = (Format)expression2;
                    yield this.translate(expression);
                }
                case 17 -> {
                    TryExpression expression = (TryExpression)expression2;
                    yield this.translate(expression);
                }
                case 18 -> {
                    LikePredicate expression = (LikePredicate)expression2;
                    yield this.translate(expression);
                }
                case 19 -> {
                    Trim expression = (Trim)expression2;
                    yield this.translate(expression);
                }
                case 20 -> {
                    SubscriptExpression expression = (SubscriptExpression)expression2;
                    yield this.translate(expression);
                }
                case 21 -> {
                    LambdaExpression expression = (LambdaExpression)expression2;
                    yield this.translate(expression);
                }
                case 22 -> {
                    Parameter expression = (Parameter)expression2;
                    yield this.translate(expression);
                }
                case 23 -> {
                    JsonExists expression = (JsonExists)expression2;
                    yield this.translate(expression);
                }
                case 24 -> {
                    JsonValue expression = (JsonValue)expression2;
                    yield this.translate(expression);
                }
                case 25 -> {
                    JsonQuery expression = (JsonQuery)expression2;
                    yield this.translate(expression);
                }
                case 26 -> {
                    JsonObject expression = (JsonObject)expression2;
                    yield this.translate(expression);
                }
                case 27 -> {
                    JsonArray expression = (JsonArray)expression2;
                    yield this.translate(expression);
                }
                case 28 -> {
                    LongLiteral expression = (LongLiteral)expression2;
                    yield this.translate(expression);
                }
                case 29 -> {
                    DoubleLiteral expression = (DoubleLiteral)expression2;
                    yield this.translate(expression);
                }
                case 30 -> {
                    StringLiteral expression = (StringLiteral)expression2;
                    yield this.translate(expression);
                }
                case 31 -> {
                    io.trino.sql.tree.BooleanLiteral expression = (io.trino.sql.tree.BooleanLiteral)expression2;
                    yield this.translate(expression);
                }
                case 32 -> {
                    DecimalLiteral expression = (DecimalLiteral)expression2;
                    yield this.translate(expression);
                }
                case 33 -> {
                    GenericLiteral expression = (GenericLiteral)expression2;
                    yield this.translate(expression);
                }
                case 34 -> {
                    BinaryLiteral expression = (BinaryLiteral)expression2;
                    yield this.translate(expression);
                }
                case 35 -> {
                    IntervalLiteral expression = (IntervalLiteral)expression2;
                    yield this.translate(expression);
                }
                case 36 -> {
                    io.trino.sql.tree.ArithmeticBinaryExpression expression = (io.trino.sql.tree.ArithmeticBinaryExpression)expression2;
                    yield this.translate(expression);
                }
                case 37 -> {
                    ArithmeticUnaryExpression expression = (ArithmeticUnaryExpression)expression2;
                    yield this.translate(expression);
                }
                case 38 -> {
                    ComparisonExpression expression = (ComparisonExpression)expression2;
                    yield this.translate(expression);
                }
                case 39 -> {
                    io.trino.sql.tree.Cast expression = (io.trino.sql.tree.Cast)expression2;
                    yield this.translate(expression);
                }
                case 40 -> {
                    io.trino.sql.tree.Row expression = (io.trino.sql.tree.Row)expression2;
                    yield this.translate(expression);
                }
                case 41 -> {
                    NotExpression expression = (NotExpression)expression2;
                    yield this.translate(expression);
                }
                case 42 -> {
                    io.trino.sql.tree.LogicalExpression expression = (io.trino.sql.tree.LogicalExpression)expression2;
                    yield this.translate(expression);
                }
                case 43 -> {
                    NullLiteral expression = (NullLiteral)expression2;
                    yield new Constant((Type)UnknownType.UNKNOWN, null);
                }
                case 44 -> {
                    CoalesceExpression expression = (CoalesceExpression)expression2;
                    yield this.translate(expression);
                }
                case 45 -> {
                    io.trino.sql.tree.IsNullPredicate expression = (io.trino.sql.tree.IsNullPredicate)expression2;
                    yield this.translate(expression);
                }
                case 46 -> {
                    IsNotNullPredicate expression = (IsNotNullPredicate)expression2;
                    yield this.translate(expression);
                }
                case 47 -> {
                    io.trino.sql.tree.BetweenPredicate expression = (io.trino.sql.tree.BetweenPredicate)expression2;
                    yield this.translate(expression);
                }
                case 48 -> {
                    IfExpression expression = (IfExpression)expression2;
                    yield this.translate(expression);
                }
                case 49 -> {
                    InPredicate expression = (InPredicate)expression2;
                    yield this.translate(expression);
                }
                case 50 -> {
                    io.trino.sql.tree.SimpleCaseExpression expression = (io.trino.sql.tree.SimpleCaseExpression)expression2;
                    yield this.translate(expression);
                }
                case 51 -> {
                    io.trino.sql.tree.SearchedCaseExpression expression = (io.trino.sql.tree.SearchedCaseExpression)expression2;
                    yield this.translate(expression);
                }
                case 52 -> {
                    NullIfExpression expression = (NullIfExpression)expression2;
                    yield this.translate(expression);
                }
                default -> throw new IllegalArgumentException("Unsupported expression (%s): %s".formatted(expr.getClass().getName(), expr));
            };
        }
        return isRoot ? result : QueryPlanner.coerceIfNecessary(this.analysis, expr, result);
    }

    private Expression translate(NullIfExpression expression) {
        return new io.trino.sql.ir.NullIfExpression(this.translateExpression(expression.getFirst()), this.translateExpression(expression.getSecond()));
    }

    private Expression translate(ArithmeticUnaryExpression expression) {
        return switch (expression.getSign()) {
            default -> throw new MatchException(null, null);
            case ArithmeticUnaryExpression.Sign.PLUS -> this.translateExpression(expression.getValue());
            case ArithmeticUnaryExpression.Sign.MINUS -> new ArithmeticNegation(this.translateExpression(expression.getValue()));
        };
    }

    private Expression translate(IntervalLiteral expression) {
        Type type;
        Type type2 = type = this.analysis.getType((io.trino.sql.tree.Expression)expression);
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return new Constant(type, switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntervalYearMonthType.class, IntervalDayTimeType.class}, (Object)type3, n)) {
            case 0 -> {
                IntervalYearMonthType t = (IntervalYearMonthType)type3;
                yield (long)expression.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(expression.getValue(), expression.getStartField(), expression.getEndField());
            }
            case 1 -> {
                IntervalDayTimeType t = (IntervalDayTimeType)type3;
                yield (long)expression.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(expression.getValue(), expression.getStartField(), expression.getEndField());
            }
            default -> throw new IllegalArgumentException("Unexpected type for IntervalLiteral: %s" + String.valueOf(type));
        });
    }

    private Expression translate(io.trino.sql.tree.SearchedCaseExpression expression) {
        return new SearchedCaseExpression((List)expression.getWhenClauses().stream().map(clause -> new WhenClause(this.translateExpression(clause.getOperand()), this.translateExpression(clause.getResult()))).collect(ImmutableList.toImmutableList()), expression.getDefaultValue().map(this::translateExpression));
    }

    private Expression translate(io.trino.sql.tree.SimpleCaseExpression expression) {
        return new SimpleCaseExpression(this.translateExpression(expression.getOperand()), (List)expression.getWhenClauses().stream().map(clause -> new WhenClause(this.translateExpression(clause.getOperand()), this.translateExpression(clause.getResult()))).collect(ImmutableList.toImmutableList()), expression.getDefaultValue().map(this::translateExpression));
    }

    private Expression translate(InPredicate expression) {
        return new io.trino.sql.ir.InPredicate(this.translateExpression(expression.getValue()), (List)((InListExpression)expression.getValueList()).getValues().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(IfExpression expression) {
        if (expression.getFalseValue().isPresent()) {
            return IrExpressions.ifExpression(this.translateExpression(expression.getCondition()), this.translateExpression(expression.getTrueValue()), this.translateExpression((io.trino.sql.tree.Expression)expression.getFalseValue().get()));
        }
        return IrExpressions.ifExpression(this.translateExpression(expression.getCondition()), this.translateExpression(expression.getTrueValue()));
    }

    private Expression translate(BinaryLiteral expression) {
        return new Constant(this.analysis.getType((io.trino.sql.tree.Expression)expression), Slices.wrappedBuffer((byte[])expression.getValue()));
    }

    private Expression translate(io.trino.sql.tree.BetweenPredicate expression) {
        return new BetweenPredicate(this.translateExpression(expression.getValue()), this.translateExpression(expression.getMin()), this.translateExpression(expression.getMax()));
    }

    private Expression translate(io.trino.sql.tree.IsNullPredicate expression) {
        return new IsNullPredicate(this.translateExpression(expression.getValue()));
    }

    private Expression translate(IsNotNullPredicate expression) {
        return new io.trino.sql.ir.NotExpression(new IsNullPredicate(this.translateExpression(expression.getValue())));
    }

    private Expression translate(CoalesceExpression expression) {
        return new io.trino.sql.ir.CoalesceExpression((List)expression.getOperands().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(GenericLiteral expression) {
        Type type = this.analysis.getType((io.trino.sql.tree.Expression)expression);
        if (type.equals((Object)JsonType.JSON)) {
            return new Constant(type, JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)expression.getValue())));
        }
        InterpretedFunctionInvoker functionInvoker = new InterpretedFunctionInvoker(this.plannerContext.getFunctionManager());
        ResolvedFunction resolvedFunction = this.plannerContext.getMetadata().getCoercion((Type)VarcharType.VARCHAR, type);
        Object value = functionInvoker.invoke(resolvedFunction, this.session.toConnectorSession(), (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)expression.getValue())));
        return new Constant(type, value);
    }

    private Expression translate(DecimalLiteral expression) {
        DecimalType type = (DecimalType)this.analysis.getType((io.trino.sql.tree.Expression)expression);
        DecimalParseResult parsed = Decimals.parse((String)expression.getValue());
        Preconditions.checkState((boolean)parsed.getType().equals((Object)type));
        return new Constant((Type)type, parsed.getObject());
    }

    private Expression translate(io.trino.sql.tree.LogicalExpression expression) {
        return new LogicalExpression(switch (expression.getOperator()) {
            default -> throw new MatchException(null, null);
            case LogicalExpression.Operator.AND -> LogicalExpression.Operator.AND;
            case LogicalExpression.Operator.OR -> LogicalExpression.Operator.OR;
        }, (List)expression.getTerms().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(io.trino.sql.tree.BooleanLiteral expression) {
        if (expression.equals((Object)io.trino.sql.tree.BooleanLiteral.TRUE_LITERAL)) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        if (expression.equals((Object)io.trino.sql.tree.BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        throw new IllegalArgumentException("Unknown boolean literal: " + String.valueOf(expression));
    }

    private Expression translate(NotExpression expression) {
        return new io.trino.sql.ir.NotExpression(this.translateExpression(expression.getValue()));
    }

    private Expression translate(io.trino.sql.tree.Row expression) {
        return new Row((List)expression.getItems().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(ComparisonExpression expression) {
        return new io.trino.sql.ir.ComparisonExpression(switch (expression.getOperator()) {
            default -> throw new MatchException(null, null);
            case ComparisonExpression.Operator.EQUAL -> ComparisonExpression.Operator.EQUAL;
            case ComparisonExpression.Operator.NOT_EQUAL -> ComparisonExpression.Operator.NOT_EQUAL;
            case ComparisonExpression.Operator.LESS_THAN -> ComparisonExpression.Operator.LESS_THAN;
            case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> ComparisonExpression.Operator.LESS_THAN_OR_EQUAL;
            case ComparisonExpression.Operator.GREATER_THAN -> ComparisonExpression.Operator.GREATER_THAN;
            case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL;
            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> ComparisonExpression.Operator.IS_DISTINCT_FROM;
        }, this.translateExpression(expression.getLeft()), this.translateExpression(expression.getRight()));
    }

    private Expression translate(io.trino.sql.tree.Cast expression) {
        return new Cast(this.translateExpression(expression.getExpression()), this.analysis.getType((io.trino.sql.tree.Expression)expression), expression.isSafe());
    }

    private Expression translate(DoubleLiteral expression) {
        return new Constant((Type)DoubleType.DOUBLE, expression.getValue());
    }

    private Expression translate(io.trino.sql.tree.ArithmeticBinaryExpression expression) {
        OperatorType operatorType = switch (expression.getOperator()) {
            default -> throw new MatchException(null, null);
            case ArithmeticBinaryExpression.Operator.ADD -> OperatorType.ADD;
            case ArithmeticBinaryExpression.Operator.SUBTRACT -> OperatorType.SUBTRACT;
            case ArithmeticBinaryExpression.Operator.MULTIPLY -> OperatorType.MULTIPLY;
            case ArithmeticBinaryExpression.Operator.DIVIDE -> OperatorType.DIVIDE;
            case ArithmeticBinaryExpression.Operator.MODULUS -> OperatorType.MODULUS;
        };
        ResolvedFunction resolvedFunction = this.plannerContext.getMetadata().resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)this.getCoercedType(expression.getLeft()), (Object)this.getCoercedType(expression.getRight())));
        return new ArithmeticBinaryExpression(resolvedFunction, switch (expression.getOperator()) {
            default -> throw new MatchException(null, null);
            case ArithmeticBinaryExpression.Operator.ADD -> ArithmeticBinaryExpression.Operator.ADD;
            case ArithmeticBinaryExpression.Operator.SUBTRACT -> ArithmeticBinaryExpression.Operator.SUBTRACT;
            case ArithmeticBinaryExpression.Operator.MULTIPLY -> ArithmeticBinaryExpression.Operator.MULTIPLY;
            case ArithmeticBinaryExpression.Operator.DIVIDE -> ArithmeticBinaryExpression.Operator.DIVIDE;
            case ArithmeticBinaryExpression.Operator.MODULUS -> ArithmeticBinaryExpression.Operator.MODULUS;
        }, this.translateExpression(expression.getLeft()), this.translateExpression(expression.getRight()));
    }

    private Type getCoercedType(io.trino.sql.tree.Expression left) {
        Type leftType = this.analysis.getCoercion(left);
        if (leftType == null) {
            leftType = this.analysis.getType(left);
        }
        return leftType;
    }

    private Expression translate(StringLiteral expression) {
        return new Constant(this.analysis.getType((io.trino.sql.tree.Expression)expression), Slices.utf8Slice((String)expression.getValue()));
    }

    private Expression translate(LongLiteral expression) {
        return new Constant(this.analysis.getType((io.trino.sql.tree.Expression)expression), expression.getParsedValue());
    }

    private Expression translate(FieldReference expression) {
        return this.getSymbolForColumn((io.trino.sql.tree.Expression)expression).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No symbol mapping for node '%s' (%s)", expression, expression.getFieldIndex())));
    }

    private Expression translate(Identifier expression) {
        LambdaArgumentDeclaration referencedLambdaArgumentDeclaration = this.analysis.getLambdaArgumentReference(expression);
        if (referencedLambdaArgumentDeclaration != null) {
            Symbol symbol = this.lambdaArguments.get(NodeRef.of((Node)referencedLambdaArgumentDeclaration));
            return symbol.toSymbolReference();
        }
        return this.getSymbolForColumn((io.trino.sql.tree.Expression)expression).map(Symbol::toSymbolReference).get();
    }

    private Expression translate(io.trino.sql.tree.FunctionCall expression) {
        if (this.analysis.isPatternNavigationFunction(expression)) {
            return this.translate((io.trino.sql.tree.Expression)expression.getArguments().getFirst(), false);
        }
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)expression);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)expression);
        return new FunctionCall(resolvedFunction, (List)expression.getArguments().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(DereferenceExpression expression) {
        if (this.analysis.isColumnReference((io.trino.sql.tree.Expression)expression)) {
            return this.getSymbolForColumn((io.trino.sql.tree.Expression)expression).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No mapping for %s", expression)));
        }
        RowType rowType = (RowType)this.analysis.getType(expression.getBase());
        String fieldName = ((Identifier)expression.getField().orElseThrow()).getValue();
        List fields = rowType.getFields();
        int index = -1;
        for (int i = 0; i < fields.size(); ++i) {
            RowType.Field field = (RowType.Field)fields.get(i);
            if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
            Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
            index = i;
        }
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)fieldName);
        return new io.trino.sql.ir.SubscriptExpression(((RowType.Field)rowType.getFields().get(index)).getType(), this.translateExpression(expression.getBase()), new Constant((Type)IntegerType.INTEGER, index + 1));
    }

    private Expression translate(Array expression) {
        Failures.checkCondition(expression.getValues().size() <= 254, (ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, "Too many arguments for array constructor", new Object[0]);
        List types = (List)expression.getValues().stream().map(this.analysis::getType).collect(ImmutableList.toImmutableList());
        List values = (List)expression.getValues().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList());
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$array").setArguments(types, values).build();
    }

    private Expression translate(CurrentCatalog unused) {
        return new FunctionCall(this.plannerContext.getMetadata().resolveBuiltinFunction("$current_catalog", (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of());
    }

    private Expression translate(CurrentSchema unused) {
        return new FunctionCall(this.plannerContext.getMetadata().resolveBuiltinFunction("$current_schema", (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of());
    }

    private Expression translate(CurrentPath unused) {
        return new FunctionCall(this.plannerContext.getMetadata().resolveBuiltinFunction("$current_path", (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of());
    }

    private Expression translate(CurrentUser unused) {
        return new FunctionCall(this.plannerContext.getMetadata().resolveBuiltinFunction("$current_user", (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of());
    }

    private Expression translate(CurrentDate unused) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("current_date").build();
    }

    private Expression translate(CurrentTime node) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$current_time").setArguments((List<Type>)ImmutableList.of((Object)this.analysis.getType((io.trino.sql.tree.Expression)node)), (List<Expression>)ImmutableList.of((Object)new Constant(this.analysis.getType((io.trino.sql.tree.Expression)node), null))).build();
    }

    private Expression translate(CurrentTimestamp node) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$current_timestamp").setArguments((List<Type>)ImmutableList.of((Object)this.analysis.getType((io.trino.sql.tree.Expression)node)), (List<Expression>)ImmutableList.of((Object)new Constant(this.analysis.getType((io.trino.sql.tree.Expression)node), null))).build();
    }

    private Expression translate(LocalTime node) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$localtime").setArguments((List<Type>)ImmutableList.of((Object)this.analysis.getType((io.trino.sql.tree.Expression)node)), (List<Expression>)ImmutableList.of((Object)new Constant(this.analysis.getType((io.trino.sql.tree.Expression)node), null))).build();
    }

    private Expression translate(LocalTimestamp node) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$localtimestamp").setArguments((List<Type>)ImmutableList.of((Object)this.analysis.getType((io.trino.sql.tree.Expression)node)), (List<Expression>)ImmutableList.of((Object)new Constant(this.analysis.getType((io.trino.sql.tree.Expression)node), null))).build();
    }

    private Expression translate(Extract node) {
        Expression value = this.translateExpression(node.getExpression());
        Type type = this.analysis.getType(node.getExpression());
        return switch (node.getField()) {
            default -> throw new MatchException(null, null);
            case Extract.Field.YEAR -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("year").addArgument(type, value).build();
            case Extract.Field.QUARTER -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("quarter").addArgument(type, value).build();
            case Extract.Field.MONTH -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("month").addArgument(type, value).build();
            case Extract.Field.WEEK -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("week").addArgument(type, value).build();
            case Extract.Field.DAY, Extract.Field.DAY_OF_MONTH -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("day").addArgument(type, value).build();
            case Extract.Field.DAY_OF_WEEK, Extract.Field.DOW -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("day_of_week").addArgument(type, value).build();
            case Extract.Field.DAY_OF_YEAR, Extract.Field.DOY -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("day_of_year").addArgument(type, value).build();
            case Extract.Field.YEAR_OF_WEEK, Extract.Field.YOW -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("year_of_week").addArgument(type, value).build();
            case Extract.Field.HOUR -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("hour").addArgument(type, value).build();
            case Extract.Field.MINUTE -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("minute").addArgument(type, value).build();
            case Extract.Field.SECOND -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("second").addArgument(type, value).build();
            case Extract.Field.TIMEZONE_MINUTE -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("timezone_minute").addArgument(type, value).build();
            case Extract.Field.TIMEZONE_HOUR -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("timezone_hour").addArgument(type, value).build();
        };
    }

    private Expression translate(AtTimeZone node) {
        FunctionCall call;
        Type valueType = this.analysis.getType(node.getValue());
        Expression value = this.translateExpression(node.getValue());
        Type timeZoneType = this.analysis.getType(node.getTimeZone());
        Expression timeZone = this.translateExpression(node.getTimeZone());
        if (valueType instanceof TimeType) {
            TimeType type = (TimeType)valueType;
            call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$at_timezone").addArgument((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)type.getPrecision()), (Expression)new Cast(value, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)((TimeType)valueType).getPrecision()))).addArgument(timeZoneType, timeZone).build();
        } else if (valueType instanceof TimeWithTimeZoneType) {
            call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$at_timezone").addArgument(valueType, value).addArgument(timeZoneType, timeZone).build();
        } else if (valueType instanceof TimestampType) {
            TimestampType type = (TimestampType)valueType;
            call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("at_timezone").addArgument((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)type.getPrecision()), (Expression)new Cast(value, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)((TimestampType)valueType).getPrecision()))).addArgument(timeZoneType, timeZone).build();
        } else if (valueType instanceof TimestampWithTimeZoneType) {
            call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("at_timezone").addArgument(valueType, value).addArgument(timeZoneType, timeZone).build();
        } else {
            throw new IllegalArgumentException("Unexpected type: " + String.valueOf(valueType));
        }
        return call;
    }

    private Expression translate(Format node) {
        List arguments = (List)node.getArguments().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList());
        List argumentTypes = (List)node.getArguments().stream().map(this.analysis::getType).collect(ImmutableList.toImmutableList());
        FunctionCall call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$format").addArgument((Type)VarcharType.VARCHAR, (Expression)arguments.get(0)).addArgument((Type)RowType.anonymous(argumentTypes.subList(1, arguments.size())), (Expression)new Row(arguments.subList(1, arguments.size()))).build();
        return call;
    }

    private Expression translate(TryExpression node) {
        Type type = this.analysis.getType((io.trino.sql.tree.Expression)node);
        Expression expression = this.translateExpression(node.getInnerExpression());
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$internal$try").addArgument(new FunctionType((List<Type>)ImmutableList.of(), type), (Expression)new io.trino.sql.ir.LambdaExpression((List<Symbol>)ImmutableList.of(), expression)).build();
    }

    private Expression translate(LikePredicate node) {
        Expression value = this.translateExpression(node.getValue());
        Expression pattern = this.translateExpression(node.getPattern());
        Optional<Expression> escape = node.getEscape().map(this::translateExpression);
        FunctionCall patternCall = escape.isPresent() ? BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like_pattern").addArgument(this.analysis.getType(node.getPattern()), pattern).addArgument(this.analysis.getType((io.trino.sql.tree.Expression)node.getEscape().get()), escape.get()).build() : BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like_pattern").addArgument(this.analysis.getType(node.getPattern()), pattern).build();
        FunctionCall call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like").addArgument(this.analysis.getType(node.getValue()), value).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)patternCall).build();
        return call;
    }

    private Expression translate(Trim node) {
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        ImmutableList.Builder arguments = ImmutableList.builder();
        arguments.add((Object)this.translateExpression(node.getTrimSource()));
        node.getTrimCharacter().map(this::translateExpression).ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        return new FunctionCall(resolvedFunction, (List<Expression>)arguments.build());
    }

    private Expression translate(SubscriptExpression node) {
        Type baseType = this.analysis.getType(node.getBase());
        if (baseType instanceof RowType) {
            RowType rowType = (RowType)baseType;
            Expression rewrittenBase = this.translateExpression(node.getBase());
            LongLiteral index = (LongLiteral)node.getIndex();
            return new io.trino.sql.ir.SubscriptExpression(this.analysis.getType((io.trino.sql.tree.Expression)node), rewrittenBase, new Constant((Type)IntegerType.INTEGER, index.getParsedValue()));
        }
        return new io.trino.sql.ir.SubscriptExpression(this.analysis.getType((io.trino.sql.tree.Expression)node), this.translateExpression(node.getBase()), this.translateExpression(node.getIndex()));
    }

    private Expression translate(LambdaExpression node) {
        Preconditions.checkState((this.analysis.getCoercion((io.trino.sql.tree.Expression)node) == null ? 1 : 0) != 0, (Object)"cannot coerce a lambda expression");
        ImmutableList.Builder newArguments = ImmutableList.builder();
        for (LambdaArgumentDeclaration argument : node.getArguments()) {
            newArguments.add((Object)this.lambdaArguments.get(NodeRef.of((Node)argument)));
        }
        Expression rewrittenBody = this.translateExpression(node.getBody());
        return new io.trino.sql.ir.LambdaExpression((List<Symbol>)newArguments.build(), rewrittenBody);
    }

    private Expression translate(Parameter node) {
        Preconditions.checkState((this.analysis.getParameters().size() > node.getId() ? 1 : 0) != 0, (Object)"Too few parameter values");
        return this.translateExpression(this.analysis.getParameters().get(NodeRef.of((Node)node)));
    }

    private Expression translate(JsonExists node) {
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        Constant failOnError = new Constant((Type)BooleanType.BOOLEAN, node.getErrorBehavior() == JsonExists.ErrorBehavior.ERROR);
        ResolvedFunction inputToJson = this.analysis.getJsonInputFunction(node.getJsonPathInvocation().getInputExpression());
        FunctionCall input = new FunctionCall(inputToJson, (List<Expression>)ImmutableList.of((Object)this.translateExpression(node.getJsonPathInvocation().getInputExpression()), (Object)failOnError));
        ParametersRow orderedParameters = this.getParametersRow(node.getJsonPathInvocation().getPathParameters(), node.getJsonPathInvocation().getPathParameters().stream().map(parameter -> this.translateExpression(parameter.getParameter())).toList(), resolvedFunction.getSignature().getArgumentType(2), failOnError);
        IrJsonPath path = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)node), orderedParameters.getParametersOrder());
        Constant pathExpression = new Constant(this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), path);
        ImmutableList.Builder arguments = ImmutableList.builder().add((Object)input).add((Object)pathExpression).add((Object)orderedParameters.getParametersRow()).add((Object)new Constant((Type)TinyintType.TINYINT, node.getErrorBehavior().ordinal()));
        return new FunctionCall(resolvedFunction, (List<Expression>)arguments.build());
    }

    private Expression translate(JsonValue node) {
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        Constant failOnError = new Constant((Type)BooleanType.BOOLEAN, node.getErrorBehavior() == JsonValue.EmptyOrErrorBehavior.ERROR);
        ResolvedFunction inputToJson = this.analysis.getJsonInputFunction(node.getJsonPathInvocation().getInputExpression());
        FunctionCall input = new FunctionCall(inputToJson, (List<Expression>)ImmutableList.of((Object)this.translateExpression(node.getJsonPathInvocation().getInputExpression()), (Object)failOnError));
        ParametersRow orderedParameters = this.getParametersRow(node.getJsonPathInvocation().getPathParameters(), node.getJsonPathInvocation().getPathParameters().stream().map(parameter -> this.translateExpression(parameter.getParameter())).toList(), resolvedFunction.getSignature().getArgumentType(2), failOnError);
        IrJsonPath path = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)node), orderedParameters.getParametersOrder());
        Constant pathExpression = new Constant(this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), path);
        ImmutableList.Builder arguments = ImmutableList.builder().add((Object)input).add((Object)pathExpression).add((Object)orderedParameters.getParametersRow()).add((Object)new Constant((Type)TinyintType.TINYINT, node.getEmptyBehavior().ordinal())).add((Object)node.getEmptyDefault().map(this::translateExpression).orElseGet(() -> new Constant(resolvedFunction.getSignature().getReturnType(), null))).add((Object)new Constant((Type)TinyintType.TINYINT, node.getErrorBehavior().ordinal())).add((Object)node.getErrorDefault().map(this::translateExpression).orElseGet(() -> new Constant(resolvedFunction.getSignature().getReturnType(), null)));
        return new FunctionCall(resolvedFunction, (List<Expression>)arguments.build());
    }

    private Expression translate(JsonQuery node) {
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        Constant failOnError = new Constant((Type)BooleanType.BOOLEAN, node.getErrorBehavior() == JsonQuery.EmptyOrErrorBehavior.ERROR);
        ResolvedFunction inputToJson = this.analysis.getJsonInputFunction(node.getJsonPathInvocation().getInputExpression());
        FunctionCall input = new FunctionCall(inputToJson, (List<Expression>)ImmutableList.of((Object)this.translateExpression(node.getJsonPathInvocation().getInputExpression()), (Object)failOnError));
        ParametersRow orderedParameters = this.getParametersRow(node.getJsonPathInvocation().getPathParameters(), node.getJsonPathInvocation().getPathParameters().stream().map(parameter -> this.translateExpression(parameter.getParameter())).toList(), resolvedFunction.getSignature().getArgumentType(2), failOnError);
        IrJsonPath path = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)node), orderedParameters.getParametersOrder());
        Constant pathExpression = new Constant(this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), path);
        ImmutableList.Builder arguments = ImmutableList.builder().add((Object)input).add((Object)pathExpression).add((Object)orderedParameters.getParametersRow()).add((Object)new Constant((Type)TinyintType.TINYINT, node.getWrapperBehavior().ordinal())).add((Object)new Constant((Type)TinyintType.TINYINT, node.getEmptyBehavior().ordinal())).add((Object)new Constant((Type)TinyintType.TINYINT, node.getErrorBehavior().ordinal()));
        FunctionCall function = new FunctionCall(resolvedFunction, (List<Expression>)arguments.build());
        Constant errorBehavior = new Constant((Type)TinyintType.TINYINT, node.getErrorBehavior().ordinal());
        Constant omitQuotes = new Constant((Type)BooleanType.BOOLEAN, node.getQuotesBehavior().orElse(JsonQuery.QuotesBehavior.KEEP) == JsonQuery.QuotesBehavior.OMIT);
        ResolvedFunction outputFunction = this.analysis.getJsonOutputFunction((Node)node);
        Record result = new FunctionCall(outputFunction, (List<Expression>)ImmutableList.of((Object)function, (Object)errorBehavior, (Object)omitQuotes));
        Type returnedType = node.getReturnedType().map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)this.plannerContext.getTypeManager()).getType(arg_0)).orElse((Type)VarcharType.VARCHAR);
        Type resultType = outputFunction.getSignature().getReturnType();
        if (!resultType.equals((Object)returnedType)) {
            result = new Cast((Expression)((Object)result), returnedType);
        }
        return result;
    }

    private Expression translate(JsonObject node) {
        Record valuesRow;
        Record keysRow;
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        if (node.getMembers().isEmpty()) {
            Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)resolvedFunction.getSignature().getArgumentType(0)));
            Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)resolvedFunction.getSignature().getArgumentType(1)));
            keysRow = new Constant((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, null);
            valuesRow = new Constant((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, null);
        } else {
            ImmutableList.Builder keys = ImmutableList.builder();
            ImmutableList.Builder values = ImmutableList.builder();
            for (JsonObjectMember member : node.getMembers()) {
                io.trino.sql.tree.Expression value = member.getValue();
                Expression rewrittenKey = this.translateExpression(member.getKey());
                keys.add((Object)rewrittenKey);
                Expression rewrittenValue = this.translateExpression(value);
                ResolvedFunction valueToJson = this.analysis.getJsonInputFunction(value);
                if (valueToJson != null) {
                    values.add((Object)new FunctionCall(valueToJson, (List<Expression>)ImmutableList.of((Object)rewrittenValue, (Object)BooleanLiteral.TRUE_LITERAL)));
                    continue;
                }
                values.add((Object)rewrittenValue);
            }
            keysRow = new Row((List<Expression>)keys.build());
            valuesRow = new Row((List<Expression>)values.build());
        }
        ImmutableList arguments = ImmutableList.builder().add((Object)keysRow).add((Object)valuesRow).add((Object)(node.isNullOnNull() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL)).add((Object)(node.isUniqueKeys() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL)).build();
        FunctionCall function = new FunctionCall(resolvedFunction, (List<Expression>)arguments);
        ResolvedFunction outputFunction = this.analysis.getJsonOutputFunction((Node)node);
        Record result = new FunctionCall(outputFunction, (List<Expression>)ImmutableList.of((Object)function, (Object)new Constant((Type)TinyintType.TINYINT, JsonQuery.EmptyOrErrorBehavior.ERROR.ordinal()), (Object)BooleanLiteral.FALSE_LITERAL));
        Type returnedType = node.getReturnedType().map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)this.plannerContext.getTypeManager()).getType(arg_0)).orElse((Type)VarcharType.VARCHAR);
        Type resultType = outputFunction.getSignature().getReturnType();
        if (!resultType.equals((Object)returnedType)) {
            result = new Cast((Expression)((Object)result), returnedType);
        }
        return result;
    }

    private Expression translate(JsonArray node) {
        Record elementsRow;
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        if (node.getElements().isEmpty()) {
            Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)resolvedFunction.getSignature().getArgumentType(0)));
            elementsRow = new Constant((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, null);
        } else {
            ImmutableList.Builder elements = ImmutableList.builder();
            for (JsonArrayElement arrayElement : node.getElements()) {
                io.trino.sql.tree.Expression element = arrayElement.getValue();
                Expression rewrittenElement = this.translateExpression(element);
                ResolvedFunction elementToJson = this.analysis.getJsonInputFunction(element);
                if (elementToJson != null) {
                    elements.add((Object)new FunctionCall(elementToJson, (List<Expression>)ImmutableList.of((Object)rewrittenElement, (Object)BooleanLiteral.TRUE_LITERAL)));
                    continue;
                }
                elements.add((Object)rewrittenElement);
            }
            elementsRow = new Row((List<Expression>)elements.build());
        }
        ImmutableList arguments = ImmutableList.builder().add((Object)elementsRow).add((Object)(node.isNullOnNull() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL)).build();
        FunctionCall function = new FunctionCall(resolvedFunction, (List<Expression>)arguments);
        ResolvedFunction outputFunction = this.analysis.getJsonOutputFunction((Node)node);
        Record result = new FunctionCall(outputFunction, (List<Expression>)ImmutableList.of((Object)function, (Object)new Constant((Type)TinyintType.TINYINT, JsonQuery.EmptyOrErrorBehavior.ERROR.ordinal()), (Object)BooleanLiteral.FALSE_LITERAL));
        Type returnedType = node.getReturnedType().map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)this.plannerContext.getTypeManager()).getType(arg_0)).orElse((Type)VarcharType.VARCHAR);
        Type resultType = outputFunction.getSignature().getReturnType();
        if (!resultType.equals((Object)returnedType)) {
            result = new Cast((Expression)((Object)result), returnedType);
        }
        return result;
    }

    private Optional<SymbolReference> tryGetMapping(io.trino.sql.tree.Expression expression) {
        Symbol symbol = this.substitutions.get(NodeRef.of((Node)expression));
        if (symbol == null) {
            symbol = this.astToSymbols.get(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope));
        }
        return Optional.ofNullable(symbol).map(Symbol::toSymbolReference);
    }

    private Optional<Symbol> getSymbolForColumn(io.trino.sql.tree.Expression expression) {
        if (!this.analysis.isColumnReference(expression)) {
            return Optional.empty();
        }
        ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)expression));
        if (this.scope.isLocalScope(field.getScope())) {
            return Optional.of(this.fieldSymbols[field.getHierarchyFieldIndex()]);
        }
        if (this.outerContext.isPresent()) {
            return Optional.of(Symbol.from(this.outerContext.get().rewrite(expression)));
        }
        return Optional.empty();
    }

    public Scope getScope() {
        return this.scope;
    }

    public ParametersRow getParametersRow(List<JsonPathParameter> pathParameters, List<Expression> rewrittenPathParameters, Type parameterRowType, Constant failOnError) {
        Object parametersOrder;
        Record parametersRow;
        if (!pathParameters.isEmpty()) {
            ImmutableList.Builder parameters = ImmutableList.builder();
            for (int i = 0; i < pathParameters.size(); ++i) {
                ResolvedFunction parameterToJson = this.analysis.getJsonInputFunction(pathParameters.get(i).getParameter());
                Expression rewrittenParameter = rewrittenPathParameters.get(i);
                if (parameterToJson != null) {
                    parameters.add((Object)new FunctionCall(parameterToJson, (List<Expression>)ImmutableList.of((Object)rewrittenParameter, (Object)failOnError)));
                    continue;
                }
                parameters.add((Object)rewrittenParameter);
            }
            parametersRow = new Cast(new Row((List<Expression>)parameters.build()), parameterRowType);
            parametersOrder = (List)pathParameters.stream().map(parameter -> parameter.getName().getCanonicalValue()).collect(ImmutableList.toImmutableList());
        } else {
            Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)parameterRowType), (Object)"invalid type of parameters row when no parameters are passed");
            parametersRow = new Constant((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, null);
            parametersOrder = ImmutableList.of();
        }
        return new ParametersRow((Expression)((Object)parametersRow), (List<String>)parametersOrder);
    }

    public static class ParametersRow {
        private final Expression parametersRow;
        private final List<String> parametersOrder;

        public ParametersRow(Expression parametersRow, List<String> parametersOrder) {
            this.parametersRow = Objects.requireNonNull(parametersRow, "parametersRow is null");
            this.parametersOrder = Objects.requireNonNull(parametersOrder, "parametersOrder is null");
        }

        public Expression getParametersRow() {
            return this.parametersRow;
        }

        public List<String> getParametersOrder() {
            return this.parametersOrder;
        }
    }
}

