/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import java.util.List;
import java.util.Set;

public class ArraySortAfterArrayDistinct
extends ExpressionRewriteRuleSet {
    private static final CatalogSchemaFunctionName ARRAY_DISTINCT_NAME = GlobalFunctionCatalog.builtinFunctionName("array_distinct");
    private static final CatalogSchemaFunctionName ARRAY_SORT_NAME = GlobalFunctionCatalog.builtinFunctionName("array_sort");

    public ArraySortAfterArrayDistinct(PlannerContext plannerContext) {
        super((Expression expression, Rule.Context context) -> ArraySortAfterArrayDistinct.rewrite(expression, plannerContext.getMetadata()));
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite(), this.patternRecognitionExpressionRewrite());
    }

    private static Expression rewrite(Expression expression, Metadata metadata) {
        if (expression instanceof SymbolReference) {
            return expression;
        }
        return ExpressionTreeRewriter.rewriteWith(new Visitor(metadata), expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;

        public Visitor(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression expression;
            FunctionCall functionCall;
            ResolvedFunction resolvedFunction;
            FunctionCall rewritten = treeRewriter.defaultRewrite(node, context);
            if (node.getFunction().getName().equals((Object)ARRAY_DISTINCT_NAME) && Iterables.getOnlyElement(rewritten.getArguments()) instanceof FunctionCall && (resolvedFunction = (functionCall = (FunctionCall)(expression = (Expression)Iterables.getOnlyElement(rewritten.getArguments()))).getFunction()).getName().equals((Object)ARRAY_SORT_NAME)) {
                List<Expression> arraySortArguments = functionCall.getArguments();
                List arraySortArgumentsTypes = resolvedFunction.getSignature().getArgumentTypes();
                FunctionCall arrayDistinctCall = BuiltinFunctionCallBuilder.resolve(this.metadata).setName("array_distinct").setArguments((List<Type>)ImmutableList.of((Object)((Type)arraySortArgumentsTypes.get(0))), (List<Expression>)ImmutableList.of((Object)arraySortArguments.get(0))).build();
                BuiltinFunctionCallBuilder arraySortCallBuilder = BuiltinFunctionCallBuilder.resolve(this.metadata).setName("array_sort").addArgument((Type)arraySortArgumentsTypes.get(0), (Expression)arrayDistinctCall);
                if (arraySortArguments.size() == 2) {
                    arraySortCallBuilder.addArgument((Type)arraySortArgumentsTypes.get(1), arraySortArguments.get(1));
                }
                return arraySortCallBuilder.build();
            }
            return rewritten;
        }
    }
}

