/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.SymbolReference;
import java.util.List;

public final class CanonicalizeExpressionRewriter {
    public static Expression canonicalizeExpression(Expression expression, PlannerContext plannerContext) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(plannerContext), expression);
    }

    private CanonicalizeExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression, PlannerContext plannerContext) {
        if (expression instanceof SymbolReference) {
            return expression;
        }
        return ExpressionTreeRewriter.rewriteWith(new Visitor(plannerContext), expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final PlannerContext plannerContext;

        public Visitor(PlannerContext plannerContext) {
            this.plannerContext = plannerContext;
        }

        @Override
        public Expression rewriteComparisonExpression(ComparisonExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.isConstant(node.getLeft()) && !this.isConstant(node.getRight())) {
                node = new ComparisonExpression(node.getOperator().flip(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite(node, context);
        }

        @Override
        public Expression rewriteArithmeticBinary(ArithmeticBinaryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if ((node.getOperator() == ArithmeticBinaryExpression.Operator.MULTIPLY || node.getOperator() == ArithmeticBinaryExpression.Operator.ADD) && this.isConstant(node.getLeft()) && !this.isConstant(node.getRight())) {
                Metadata metadata = this.plannerContext.getMetadata();
                node = new ArithmeticBinaryExpression(metadata.resolveOperator(switch (node.getOperator()) {
                    case ArithmeticBinaryExpression.Operator.ADD -> OperatorType.ADD;
                    case ArithmeticBinaryExpression.Operator.MULTIPLY -> OperatorType.MULTIPLY;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)node.getOperator()));
                }, (List<? extends Type>)ImmutableList.of((Object)node.getFunction().getSignature().getArgumentType(1), (Object)node.getFunction().getSignature().getArgumentType(0))), node.getOperator(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite(node, context);
        }

        @Override
        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression argument;
            Type argumentType;
            CatalogSchemaFunctionName functionName = node.getFunction().getName();
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("date")) && node.getArguments().size() == 1 && ((argumentType = (argument = node.getArguments().get(0)).type()) instanceof TimestampType || argumentType instanceof TimestampWithTimeZoneType || argumentType instanceof VarcharType)) {
                return new Cast(treeRewriter.rewrite(argument, context), (Type)DateType.DATE);
            }
            return treeRewriter.defaultRewrite(node, context);
        }

        private boolean isConstant(Expression expression) {
            return expression instanceof Constant;
        }
    }
}

