/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.spi.type.RowType;
import io.trino.sql.ir.DefaultTraversalVisitor;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import java.util.Collection;
import java.util.List;
import java.util.Set;

class DereferencePushdown {
    private DereferencePushdown() {
    }

    public static Set<SubscriptExpression> extractRowSubscripts(Collection<Expression> expressions, boolean allowOverlap) {
        Set symbolReferencesAndRowSubscripts;
        Set candidateExpressions = symbolReferencesAndRowSubscripts = (Set)expressions.stream().flatMap(expression -> DereferencePushdown.getSymbolReferencesAndRowSubscripts(expression).stream()).collect(ImmutableSet.toImmutableSet());
        if (!allowOverlap) {
            candidateExpressions = (Set)symbolReferencesAndRowSubscripts.stream().filter(expression -> !DereferencePushdown.prefixExists(expression, symbolReferencesAndRowSubscripts)).collect(ImmutableSet.toImmutableSet());
        }
        return (Set)candidateExpressions.stream().filter(SubscriptExpression.class::isInstance).map(SubscriptExpression.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    public static boolean exclusiveDereferences(Set<Expression> projections) {
        return projections.stream().allMatch(expression -> expression instanceof SymbolReference || expression instanceof SubscriptExpression && DereferencePushdown.isRowSubscriptChain((SubscriptExpression)expression) && !DereferencePushdown.prefixExists(expression, projections));
    }

    public static Symbol getBase(SubscriptExpression expression) {
        return (Symbol)Iterables.getOnlyElement(SymbolsExtractor.extractAll(expression));
    }

    private static List<Expression> getSymbolReferencesAndRowSubscripts(Expression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new DefaultTraversalVisitor<ImmutableList.Builder<Expression>>(){

            @Override
            protected Void visitSubscriptExpression(SubscriptExpression node, ImmutableList.Builder<Expression> context) {
                if (DereferencePushdown.isRowSubscriptChain(node)) {
                    context.add((Object)node);
                }
                return null;
            }

            @Override
            protected Void visitSymbolReference(SymbolReference node, ImmutableList.Builder<Expression> context) {
                context.add((Object)node);
                return null;
            }

            @Override
            protected Void visitLambdaExpression(LambdaExpression node, ImmutableList.Builder<Expression> context) {
                return null;
            }
        }.process(expression, builder);
        return builder.build();
    }

    private static boolean isRowSubscriptChain(SubscriptExpression expression) {
        if (!(expression.getBase().type() instanceof RowType)) {
            return false;
        }
        return expression.getBase() instanceof SymbolReference || expression.getBase() instanceof SubscriptExpression && DereferencePushdown.isRowSubscriptChain((SubscriptExpression)expression.getBase());
    }

    private static boolean prefixExists(Expression expression, Set<Expression> expressions) {
        Expression current = expression;
        while (current instanceof SubscriptExpression) {
            if (!expressions.contains(current = ((SubscriptExpression)current).getBase())) continue;
            return true;
        }
        Verify.verify((boolean)(current instanceof SymbolReference));
        return false;
    }
}

