/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.SetOperationNodeTranslator;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.List;
import java.util.Objects;

public class ImplementExceptAll
implements Rule<ExceptNode> {
    private static final Pattern<ExceptNode> PATTERN = Patterns.except().with(Patterns.Except.distinct().equalTo((Object)false));
    private final Metadata metadata;

    public ImplementExceptAll(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<ExceptNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ExceptNode node, Captures captures, Rule.Context context) {
        SetOperationNodeTranslator translator = new SetOperationNodeTranslator(context.getSession(), this.metadata, context.getSymbolAllocator(), context.getIdAllocator());
        SetOperationNodeTranslator.TranslationResult result = translator.makeSetContainmentPlanForAll(node);
        Preconditions.checkState((result.getCountSymbols().size() > 0 ? 1 : 0) != 0, (Object)"ExceptNode translation result has no count symbols");
        ResolvedFunction greatest = this.metadata.resolveBuiltinFunction("greatest", TypeSignatureProvider.fromTypes(new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        Record count = result.getCountSymbols().get(0).toSymbolReference();
        for (int i = 1; i < result.getCountSymbols().size(); ++i) {
            count = new FunctionCall(greatest, (List<Expression>)ImmutableList.of((Object)new ArithmeticBinaryExpression(this.metadata.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)((Object)count), result.getCountSymbols().get(i).toSymbolReference()), (Object)new Constant((Type)BigintType.BIGINT, 0L)));
        }
        ComparisonExpression removeExtraRows = new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, result.getRowNumberSymbol().toSymbolReference(), (Expression)((Object)count));
        FilterNode filter = new FilterNode(context.getIdAllocator().getNextId(), result.getPlanNode(), removeExtraRows);
        ProjectNode project = new ProjectNode(context.getIdAllocator().getNextId(), filter, Assignments.identity(node.getOutputSymbols()));
        return Rule.Result.ofPlanNode(project);
    }
}

