/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InlineProjectIntoFilter
implements Rule<FilterNode> {
    private static final Capture<ProjectNode> PROJECTION = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.project().capturedAs(PROJECTION)));

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
        Set complexConjunctSymbols;
        ProjectNode projectNode = (ProjectNode)captures.get(PROJECTION);
        List<Expression> filterConjuncts = IrUtils.extractConjuncts(node.getPredicate());
        Map<Boolean, List<Expression>> conjuncts = filterConjuncts.stream().collect(Collectors.partitioningBy(SymbolReference.class::isInstance));
        List<Expression> simpleConjuncts = conjuncts.get(true);
        List<Expression> complexConjuncts = conjuncts.get(false);
        Set simpleUniqueConjuncts = (Set)simpleConjuncts.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        Sets.SetView simpleConjunctsToInline = Sets.difference((Set)simpleUniqueConjuncts, (Set)(complexConjunctSymbols = (Set)SymbolsExtractor.extractUnique(complexConjuncts).stream().map(Symbol::toSymbolReference).collect(ImmutableSet.toImmutableSet())));
        if (simpleConjunctsToInline.isEmpty()) {
            return Rule.Result.empty();
        }
        ImmutableList.Builder newConjuncts = ImmutableList.builder();
        Assignments.Builder newAssignments = Assignments.builder();
        Assignments.Builder postFilterAssignmentsBuilder = Assignments.builder();
        for (Expression conjunct : filterConjuncts) {
            if (simpleConjunctsToInline.contains(conjunct)) {
                Expression expression = projectNode.getAssignments().get(Symbol.from(conjunct));
                if (expression == null || expression instanceof SymbolReference) {
                    newConjuncts.add((Object)conjunct);
                    continue;
                }
                newConjuncts.add((Object)expression);
                newAssignments.putIdentities(SymbolsExtractor.extractUnique(expression));
                postFilterAssignmentsBuilder.put(Symbol.from(conjunct), BooleanLiteral.TRUE_LITERAL);
                continue;
            }
            newConjuncts.add((Object)conjunct);
        }
        Assignments postFilterAssignments = postFilterAssignmentsBuilder.build();
        if (postFilterAssignments.isEmpty()) {
            return Rule.Result.empty();
        }
        Set<Symbol> postFilterSymbols = postFilterAssignments.getSymbols();
        newAssignments.putAll(projectNode.getAssignments().filter(symbol -> !postFilterSymbols.contains(symbol)));
        HashMap<Symbol, Expression> outputAssignments = new HashMap<Symbol, Expression>();
        outputAssignments.putAll(Assignments.identity(node.getOutputSymbols()).getMap());
        outputAssignments.putAll(postFilterAssignments.getMap());
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new FilterNode(node.getId(), new ProjectNode(projectNode.getId(), projectNode.getSource(), newAssignments.build()), IrUtils.combineConjuncts((Collection<Expression>)newConjuncts.build())), Assignments.builder().putAll(outputAssignments).build()));
    }
}

