/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import java.util.List;

public final class PushDownNegationsExpressionRewriter {
    public static Expression pushDownNegations(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(), expression);
    }

    private PushDownNegationsExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        @Override
        public Expression rewriteNotExpression(NotExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Record child;
            Object predicates;
            Expression expression = node.getValue();
            if (expression instanceof LogicalExpression) {
                LogicalExpression child2 = (LogicalExpression)expression;
                predicates = IrUtils.extractPredicates(child2);
                List negatedPredicates = (List)predicates.stream().map(predicate -> treeRewriter.rewrite(new NotExpression((Expression)predicate), context)).collect(ImmutableList.toImmutableList());
                return IrUtils.combinePredicates(child2.getOperator().flip(), negatedPredicates);
            }
            predicates = node.getValue();
            if (predicates instanceof ComparisonExpression && ((ComparisonExpression)(child = (ComparisonExpression)predicates)).getOperator() != ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                ComparisonExpression.Operator operator = ((ComparisonExpression)child).getOperator();
                Expression left = ((ComparisonExpression)child).getLeft();
                Expression right = ((ComparisonExpression)child).getRight();
                Type leftType = left.type();
                Type rightType = right.type();
                if ((this.typeHasNaN(leftType) || this.typeHasNaN(rightType)) && (operator == ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL || operator == ComparisonExpression.Operator.GREATER_THAN || operator == ComparisonExpression.Operator.LESS_THAN_OR_EQUAL || operator == ComparisonExpression.Operator.LESS_THAN)) {
                    return new NotExpression(new ComparisonExpression(operator, treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context)));
                }
                return new ComparisonExpression(operator.negate(), treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context));
            }
            expression = node.getValue();
            if (expression instanceof NotExpression) {
                child = (NotExpression)expression;
                return treeRewriter.rewrite(((NotExpression)child).getValue(), context);
            }
            return new NotExpression(treeRewriter.rewrite(node.getValue(), context));
        }

        private boolean typeHasNaN(Type type) {
            return type instanceof DoubleType || type instanceof RealType;
        }
    }
}

