/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.type.DateType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import java.util.Locale;
import java.util.Objects;

public class RemoveRedundantDateTrunc
extends ExpressionRewriteRuleSet {
    public RemoveRedundantDateTrunc(PlannerContext plannerContext) {
        super((Expression expression, Rule.Context context) -> RemoveRedundantDateTrunc.rewrite(expression, context.getSession(), plannerContext));
    }

    private static Expression rewrite(Expression expression, Session session, PlannerContext plannerContext) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        return ExpressionTreeRewriter.rewriteWith(new Visitor(session, plannerContext), expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Session session;
        private final PlannerContext plannerContext;

        public Visitor(Session session, PlannerContext plannerContext) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        }

        @Override
        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            CatalogSchemaFunctionName functionName = node.getFunction().getName();
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("date_trunc")) && node.getArguments().size() == 2) {
                Slice unitValue;
                Expression unitExpression = node.getArguments().get(0);
                Expression argument = node.getArguments().get(1);
                if (argument.type() == DateType.DATE && unitExpression.type() instanceof VarcharType && unitExpression instanceof Constant && (unitValue = (Slice)new IrExpressionInterpreter(unitExpression, this.plannerContext, this.session).optimize(NoOpSymbolResolver.INSTANCE)) != null && "day".equals(unitValue.toStringUtf8().toLowerCase(Locale.ENGLISH))) {
                    return treeRewriter.rewrite(argument, context);
                }
            }
            return treeRewriter.defaultRewrite(node, context);
        }
    }
}

