/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;

public class RemoveRedundantLimit
implements Rule<LimitNode> {
    private static final Pattern<LimitNode> PATTERN = Patterns.limit();

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode limit, Captures captures, Rule.Context context) {
        if (limit.getCount() == 0L) {
            return Rule.Result.ofPlanNode(new ValuesNode(limit.getId(), limit.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        if (QueryCardinalityUtil.isAtMost(limit.getSource(), context.getLookup(), limit.getCount())) {
            return Rule.Result.ofPlanNode(limit.getSource());
        }
        return Rule.Result.empty();
    }
}

