/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Constant;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.List;

public class ReplaceRedundantJoinWithProject
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        Lookup lookup = context.getLookup();
        PlanNode left = node.getLeft();
        PlanNode right = node.getRight();
        return switch (node.getType()) {
            default -> throw new MatchException(null, null);
            case JoinType.INNER -> Rule.Result.empty();
            case JoinType.LEFT -> {
                if (!QueryCardinalityUtil.isEmpty(left, lookup) && QueryCardinalityUtil.isEmpty(right, lookup)) {
                    yield Rule.Result.ofPlanNode(ReplaceRedundantJoinWithProject.appendNulls(left, node.getLeftOutputSymbols(), node.getRightOutputSymbols(), context.getIdAllocator()));
                }
                yield Rule.Result.empty();
            }
            case JoinType.RIGHT -> {
                if (QueryCardinalityUtil.isEmpty(left, lookup) && !QueryCardinalityUtil.isEmpty(right, lookup)) {
                    yield Rule.Result.ofPlanNode(ReplaceRedundantJoinWithProject.appendNulls(right, node.getRightOutputSymbols(), node.getLeftOutputSymbols(), context.getIdAllocator()));
                }
                yield Rule.Result.empty();
            }
            case JoinType.FULL -> QueryCardinalityUtil.isEmpty(left, lookup) && !QueryCardinalityUtil.isEmpty(right, lookup) ? Rule.Result.ofPlanNode(ReplaceRedundantJoinWithProject.appendNulls(right, node.getRightOutputSymbols(), node.getLeftOutputSymbols(), context.getIdAllocator())) : (!QueryCardinalityUtil.isEmpty(left, lookup) && QueryCardinalityUtil.isEmpty(right, lookup) ? Rule.Result.ofPlanNode(ReplaceRedundantJoinWithProject.appendNulls(left, node.getLeftOutputSymbols(), node.getRightOutputSymbols(), context.getIdAllocator())) : Rule.Result.empty());
        };
    }

    private static ProjectNode appendNulls(PlanNode source, List<Symbol> sourceOutputs, List<Symbol> nullSymbols, PlanNodeIdAllocator idAllocator) {
        Assignments.Builder assignments = Assignments.builder().putIdentities(sourceOutputs);
        nullSymbols.forEach(symbol -> assignments.put((Symbol)symbol, new Constant(symbol.getType(), null)));
        return new ProjectNode(idAllocator.getNextId(), source, assignments.build());
    }
}

