/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.planner.iterative.rule.ExtractCommonPredicatesExpressionRewriter;
import io.trino.sql.planner.iterative.rule.NormalizeOrExpressionRewriter;
import io.trino.sql.planner.iterative.rule.PushDownNegationsExpressionRewriter;
import java.util.Objects;
import java.util.Set;

public class SimplifyExpressions
extends ExpressionRewriteRuleSet {
    public static Expression rewrite(Expression expression, Session session, PlannerContext plannerContext) {
        Expression expression2;
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        expression = PushDownNegationsExpressionRewriter.pushDownNegations(expression);
        expression = ExtractCommonPredicatesExpressionRewriter.extractCommonPredicates(expression);
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(expression = NormalizeOrExpressionRewriter.normalizeOrExpression(expression), plannerContext, session);
        Object optimized = interpreter.optimize(NoOpSymbolResolver.INSTANCE);
        if (optimized instanceof Expression) {
            Expression optimizedExpression = (Expression)optimized;
            expression2 = optimizedExpression;
        } else {
            expression2 = new Constant(expression.type(), optimized);
        }
        return expression2;
    }

    public SimplifyExpressions(PlannerContext plannerContext) {
        super(SimplifyExpressions.createRewrite(plannerContext));
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite(), this.patternRecognitionExpressionRewrite());
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(PlannerContext plannerContext) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        return (expression, context) -> SimplifyExpressions.rewrite(expression, context.getSession(), plannerContext);
    }
}

