/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class SimplifyFilterPredicate
implements Rule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
        List<Expression> conjuncts = IrUtils.extractConjuncts(node.getPredicate());
        ImmutableList.Builder newConjuncts = ImmutableList.builder();
        boolean simplified = false;
        Iterator<Expression> iterator = conjuncts.iterator();
        while (iterator.hasNext()) {
            Optional simplifiedConjunct;
            Expression conjunct;
            Expression expression = conjunct = iterator.next();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NullIfExpression.class, SearchedCaseExpression.class, SimpleCaseExpression.class}, (Object)expression, n)) {
                case 0: {
                    NullIfExpression expression2 = (NullIfExpression)expression;
                    Optional<Object> optional = Optional.of(LogicalExpression.and(expression2.getFirst(), SimplifyFilterPredicate.isFalseOrNullPredicate(expression2.getSecond())));
                    break;
                }
                case 1: {
                    SearchedCaseExpression expression3 = (SearchedCaseExpression)expression;
                    Optional<Object> optional = SimplifyFilterPredicate.simplify(expression3);
                    break;
                }
                case 2: {
                    SimpleCaseExpression expression4 = (SimpleCaseExpression)expression;
                    Optional<Object> optional = SimplifyFilterPredicate.simplify(expression4);
                    break;
                }
                default: {
                    Optional<Object> optional = simplifiedConjunct = Optional.empty();
                }
            }
            if (simplifiedConjunct.isPresent()) {
                simplified = true;
                newConjuncts.add((Object)((Expression)simplifiedConjunct.get()));
                continue;
            }
            newConjuncts.add((Object)conjunct);
        }
        if (!simplified) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new FilterNode(node.getId(), node.getSource(), IrUtils.combineConjuncts((Collection<Expression>)newConjuncts.build())));
    }

    private static Optional<Expression> simplify(Expression condition, Expression trueValue, Optional<Expression> falseValue) {
        if (trueValue.equals(BooleanLiteral.TRUE_LITERAL) && (falseValue.isEmpty() || SimplifyFilterPredicate.isNotTrue(falseValue.get()))) {
            return Optional.of(condition);
        }
        if (SimplifyFilterPredicate.isNotTrue(trueValue) && falseValue.isPresent() && falseValue.get().equals(BooleanLiteral.TRUE_LITERAL)) {
            return Optional.of(SimplifyFilterPredicate.isFalseOrNullPredicate(condition));
        }
        if (falseValue.isPresent() && falseValue.get().equals(trueValue) && DeterminismEvaluator.isDeterministic(trueValue)) {
            return Optional.of(trueValue);
        }
        if (SimplifyFilterPredicate.isNotTrue(trueValue) && (falseValue.isEmpty() || SimplifyFilterPredicate.isNotTrue(falseValue.get()))) {
            return Optional.of(BooleanLiteral.FALSE_LITERAL);
        }
        if (condition.equals(BooleanLiteral.TRUE_LITERAL)) {
            return Optional.of(trueValue);
        }
        if (SimplifyFilterPredicate.isNotTrue(condition)) {
            return Optional.of(falseValue.orElse(BooleanLiteral.FALSE_LITERAL));
        }
        return Optional.empty();
    }

    private static Optional<Expression> simplify(SearchedCaseExpression caseExpression) {
        Expression operand2;
        ImmutableList.Builder builder;
        Optional<Expression> defaultValue = caseExpression.getDefaultValue();
        if (caseExpression.getWhenClauses().size() == 1) {
            return SimplifyFilterPredicate.simplify(caseExpression.getWhenClauses().getFirst().getOperand(), caseExpression.getWhenClauses().getFirst().getResult(), defaultValue);
        }
        List operands = (List)caseExpression.getWhenClauses().stream().map(WhenClause::getOperand).collect(ImmutableList.toImmutableList());
        List results = (List)caseExpression.getWhenClauses().stream().map(WhenClause::getResult).collect(ImmutableList.toImmutableList());
        long trueResultsCount = results.stream().filter(result -> result.equals(BooleanLiteral.TRUE_LITERAL)).count();
        long notTrueResultsCount = results.stream().filter(SimplifyFilterPredicate::isNotTrue).count();
        if (trueResultsCount == (long)results.size() && defaultValue.isPresent() && defaultValue.get().equals(BooleanLiteral.TRUE_LITERAL)) {
            return Optional.of(BooleanLiteral.TRUE_LITERAL);
        }
        if (notTrueResultsCount == (long)results.size() && (defaultValue.isEmpty() || SimplifyFilterPredicate.isNotTrue(defaultValue.get()))) {
            return Optional.of(BooleanLiteral.FALSE_LITERAL);
        }
        if (trueResultsCount == 1L && notTrueResultsCount == (long)(results.size() - 1) && (defaultValue.isEmpty() || SimplifyFilterPredicate.isNotTrue(defaultValue.get()))) {
            builder = ImmutableList.builder();
            for (WhenClause whenClause : caseExpression.getWhenClauses()) {
                operand2 = whenClause.getOperand();
                Expression result2 = whenClause.getResult();
                if (SimplifyFilterPredicate.isNotTrue(result2)) {
                    builder.add((Object)SimplifyFilterPredicate.isFalseOrNullPredicate(operand2));
                    continue;
                }
                builder.add((Object)operand2);
                return Optional.of(IrUtils.combineConjuncts((Collection<Expression>)builder.build()));
            }
        }
        if (notTrueResultsCount == (long)results.size() && defaultValue.isPresent() && defaultValue.get().equals(BooleanLiteral.TRUE_LITERAL)) {
            builder = ImmutableList.builder();
            operands.forEach(operand -> builder.add((Object)SimplifyFilterPredicate.isFalseOrNullPredicate(operand)));
            return Optional.of(IrUtils.combineConjuncts((Collection<Expression>)builder.build()));
        }
        ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
        for (WhenClause whenClause : caseExpression.getWhenClauses()) {
            operand2 = whenClause.getOperand();
            if (operand2.equals(BooleanLiteral.TRUE_LITERAL)) {
                if (whenClauses.isEmpty()) {
                    return Optional.of(whenClause.getResult());
                }
                return Optional.of(new SearchedCaseExpression(whenClauses, Optional.of(whenClause.getResult())));
            }
            if (SimplifyFilterPredicate.isNotTrue(operand2)) continue;
            whenClauses.add(whenClause);
        }
        if (whenClauses.isEmpty()) {
            return Optional.of(defaultValue.orElse(BooleanLiteral.FALSE_LITERAL));
        }
        if (whenClauses.size() < caseExpression.getWhenClauses().size()) {
            return Optional.of(new SearchedCaseExpression(whenClauses, defaultValue));
        }
        return Optional.empty();
    }

    private static Optional<Expression> simplify(SimpleCaseExpression caseExpression) {
        Constant literal;
        Optional<Expression> defaultValue = caseExpression.getDefaultValue();
        Expression expression = caseExpression.getOperand();
        if (expression instanceof Constant && (literal = (Constant)expression).getValue() == null) {
            return Optional.of(defaultValue.orElse(BooleanLiteral.FALSE_LITERAL));
        }
        List results = (List)caseExpression.getWhenClauses().stream().map(WhenClause::getResult).collect(ImmutableList.toImmutableList());
        if (results.stream().allMatch(result -> result.equals(BooleanLiteral.TRUE_LITERAL)) && defaultValue.isPresent() && defaultValue.get().equals(BooleanLiteral.TRUE_LITERAL)) {
            return Optional.of(BooleanLiteral.TRUE_LITERAL);
        }
        if (results.stream().allMatch(SimplifyFilterPredicate::isNotTrue) && (defaultValue.isEmpty() || SimplifyFilterPredicate.isNotTrue(defaultValue.get()))) {
            return Optional.of(BooleanLiteral.FALSE_LITERAL);
        }
        return Optional.empty();
    }

    private static boolean isNotTrue(Expression expression) {
        Constant literal;
        return expression.equals(BooleanLiteral.FALSE_LITERAL) || expression instanceof Constant && (literal = (Constant)expression).getValue() == null;
    }

    private static Expression isFalseOrNullPredicate(Expression expression) {
        return LogicalExpression.or(new IsNullPredicate(expression), new NotExpression(expression));
    }
}

