/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.type.UnknownType;
import java.util.ArrayDeque;

public class UnwrapRowSubscript
extends ExpressionRewriteRuleSet {
    public UnwrapRowSubscript() {
        super((expression, context) -> ExpressionTreeRewriter.rewriteWith(new Rewriter(), expression));
    }

    private static class Rewriter
    extends ExpressionRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public Expression rewriteSubscriptExpression(SubscriptExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Cast cast;
            Type type;
            Expression base = treeRewriter.rewrite(node.getBase(), context);
            ArrayDeque<Coercion> coercions = new ArrayDeque<Coercion>();
            while (base instanceof Cast && (type = (cast = (Cast)base).getType()) instanceof RowType) {
                RowType rowType = (RowType)type;
                int index = (int)((Long)((Constant)node.getIndex()).getValue()).longValue();
                Type type2 = ((RowType.Field)rowType.getFields().get(index - 1)).getType();
                if (!(type2 instanceof UnknownType)) {
                    coercions.push(new Coercion(type2, cast.isSafe()));
                }
                base = cast.getExpression();
            }
            if (base instanceof Row) {
                Row row = (Row)base;
                int index = (int)((Long)((Constant)node.getIndex()).getValue()).longValue();
                Expression result = row.getItems().get(index - 1);
                while (!coercions.isEmpty()) {
                    Coercion coercion = (Coercion)coercions.pop();
                    result = new Cast(result, coercion.getType(), coercion.isSafe());
                }
                return result;
            }
            return treeRewriter.defaultRewrite(node, context);
        }
    }

    private static class Coercion {
        private final Type type;
        private final boolean safe;

        public Coercion(Type type, boolean safe) {
            this.type = type;
            this.safe = safe;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isSafe() {
            return this.safe;
        }
    }
}

