/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConstantProperty;
import io.trino.spi.connector.GroupingProperty;
import io.trino.spi.connector.LocalProperty;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.optimizations.ActualProperties;
import io.trino.sql.planner.optimizations.LocalProperties;
import io.trino.sql.planner.optimizations.StreamPropertyDerivations;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.DynamicFilterSourceNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.MergeProcessorNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SimpleTableExecuteNode;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableUpdateNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class PropertyDerivations {
    private PropertyDerivations() {
    }

    public static ActualProperties derivePropertiesRecursively(PlanNode node, PlannerContext plannerContext, Session session) {
        List inputProperties = (List)node.getSources().stream().map(source -> PropertyDerivations.derivePropertiesRecursively(source, plannerContext, session)).collect(ImmutableList.toImmutableList());
        return PropertyDerivations.deriveProperties(node, inputProperties, plannerContext, session);
    }

    public static ActualProperties deriveProperties(PlanNode node, List<ActualProperties> inputProperties, PlannerContext plannerContext, Session session) {
        ActualProperties output = node.accept(new Visitor(plannerContext, session), inputProperties);
        output.getNodePartitioning().ifPresent(partitioning -> Verify.verify((boolean)node.getOutputSymbols().containsAll(partitioning.getColumns()), (String)"Node-level partitioning properties contain columns not present in node's output", (Object[])new Object[0]));
        Verify.verify((boolean)node.getOutputSymbols().containsAll(output.getConstants().keySet()), (String)"Node-level constant properties contain columns not present in node's output", (Object[])new Object[0]);
        Set localPropertyColumns = output.getLocalProperties().stream().flatMap(property -> property.getColumns().stream()).collect(Collectors.toSet());
        Verify.verify((boolean)node.getOutputSymbols().containsAll(localPropertyColumns), (String)"Node-level local properties contain columns not present in node's output", (Object[])new Object[0]);
        return output;
    }

    public static ActualProperties streamBackdoorDeriveProperties(PlanNode node, List<ActualProperties> inputProperties, PlannerContext plannerContext, Session session) {
        return node.accept(new Visitor(plannerContext, session), inputProperties);
    }

    static boolean spillPossible(Session session, JoinType joinType) {
        if (!SystemSessionProperties.isSpillEnabled(session)) {
            return false;
        }
        return switch (joinType) {
            default -> throw new MatchException(null, null);
            case JoinType.INNER, JoinType.LEFT -> true;
            case JoinType.RIGHT, JoinType.FULL -> false;
        };
    }

    public static Optional<Symbol> filterIfMissing(Collection<Symbol> columns, Symbol column) {
        if (columns.contains(column)) {
            return Optional.of(column);
        }
        return Optional.empty();
    }

    public static Optional<Symbol> filterOrRewrite(Collection<Symbol> columns, Collection<JoinNode.EquiJoinClause> equalities, Symbol column) {
        if (columns.contains(column)) {
            return Optional.of(column);
        }
        for (JoinNode.EquiJoinClause equality : equalities) {
            if (equality.getLeft().equals(column) && columns.contains(equality.getRight())) {
                return Optional.of(equality.getRight());
            }
            if (!equality.getRight().equals(column) || !columns.contains(equality.getLeft())) continue;
            return Optional.of(equality.getLeft());
        }
        return Optional.empty();
    }

    private static Optional<Symbol> rewriteExpression(Map<Symbol, Expression> assignments, Expression expression) {
        if (!(expression instanceof CoalesceExpression)) {
            return Optional.empty();
        }
        ImmutableSet arguments = ImmutableSet.copyOf(((CoalesceExpression)expression).getOperands());
        if (!arguments.stream().allMatch(SymbolReference.class::isInstance)) {
            return Optional.empty();
        }
        for (Map.Entry<Symbol, Expression> entry : assignments.entrySet()) {
            if (!(entry.getValue() instanceof CoalesceExpression)) continue;
            ImmutableSet candidateArguments = ImmutableSet.copyOf(((CoalesceExpression)entry.getValue()).getOperands());
            if (!candidateArguments.stream().allMatch(SymbolReference.class::isInstance)) {
                return Optional.empty();
            }
            if (!candidateArguments.equals(arguments)) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    private static class Visitor
    extends PlanVisitor<ActualProperties, List<ActualProperties>> {
        private final PlannerContext plannerContext;
        private final Session session;

        public Visitor(PlannerContext plannerContext, Session session) {
            this.plannerContext = plannerContext;
            this.session = session;
        }

        @Override
        protected ActualProperties visitPlan(PlanNode node, List<ActualProperties> inputProperties) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        @Override
        public ActualProperties visitExplainAnalyze(ExplainAnalyzeNode node, List<ActualProperties> inputProperties) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSinglePartition()).build();
        }

        @Override
        public ActualProperties visitOutput(OutputNode node, List<ActualProperties> inputProperties) {
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translate(column -> PropertyDerivations.filterIfMissing(node.getOutputSymbols(), column));
        }

        @Override
        public ActualProperties visitEnforceSingleRow(EnforceSingleRowNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitAssignUniqueId(AssignUniqueId node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ImmutableList.Builder newLocalProperties = ImmutableList.builder();
            newLocalProperties.addAll(properties.getLocalProperties());
            newLocalProperties.add((Object)new GroupingProperty((Collection)ImmutableList.of((Object)node.getIdColumn())));
            node.getSource().getOutputSymbols().forEach(column -> newLocalProperties.add((Object)new ConstantProperty(column)));
            if (properties.getNodePartitioning().isPresent()) {
                return ActualProperties.builderFrom(properties).local((List<? extends LocalProperty<Symbol>>)newLocalProperties.build()).build();
            }
            return ActualProperties.builderFrom(properties).global(ActualProperties.Global.partitionedOn(SystemPartitioningHandle.ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of((Object)node.getIdColumn()))).local((List<? extends LocalProperty<Symbol>>)newLocalProperties.build()).build();
        }

        @Override
        public ActualProperties visitApply(ApplyNode node, List<ActualProperties> inputProperties) {
            throw new IllegalArgumentException("Unexpected node: " + node.getClass().getName());
        }

        @Override
        public ActualProperties visitCorrelatedJoin(CorrelatedJoinNode node, List<ActualProperties> inputProperties) {
            throw new IllegalArgumentException("Unexpected node: " + node.getClass().getName());
        }

        @Override
        public ActualProperties visitMarkDistinct(MarkDistinctNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitWindow(WindowNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            Optional<OrderingScheme> orderingScheme = node.getOrderingScheme();
            if (ImmutableSet.copyOf(node.getPartitionBy()).equals(node.getPrePartitionedInputs()) && (orderingScheme.isEmpty() || node.getPreSortedOrderPrefix() == orderingScheme.get().getOrderBy().size())) {
                return properties;
            }
            ImmutableList.Builder localProperties = ImmutableList.builder();
            if (!node.getPrePartitionedInputs().isEmpty()) {
                GroupingProperty prePartitionedProperty = new GroupingProperty(node.getPrePartitionedInputs());
                for (LocalProperty<Symbol> localProperty : properties.getLocalProperties()) {
                    if (!prePartitionedProperty.isSimplifiedBy(localProperty)) break;
                    localProperties.add(localProperty);
                }
            }
            if (!node.getPartitionBy().isEmpty()) {
                localProperties.add((Object)new GroupingProperty(node.getPartitionBy()));
            }
            orderingScheme.ifPresent(ordering -> localProperties.addAll(ordering.toLocalProperties()));
            return ActualProperties.builderFrom(properties).local(LocalProperties.normalizeAndPrune(localProperties.build())).build();
        }

        @Override
        public ActualProperties visitPatternRecognition(PatternRecognitionNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ActualProperties translatedProperties = properties.translate(symbol -> node.getOutputSymbols().contains(symbol) ? Optional.of(symbol) : Optional.empty());
            Optional<OrderingScheme> orderingScheme = node.getOrderingScheme();
            if (ImmutableSet.copyOf(node.getPartitionBy()).equals(node.getPrePartitionedInputs()) && (orderingScheme.isEmpty() || node.getPreSortedOrderPrefix() == orderingScheme.get().getOrderBy().size()) && (node.getRowsPerMatch() == RowsPerMatch.WINDOW || node.getRowsPerMatch() == RowsPerMatch.ONE || node.getSkipToPosition() == SkipToPosition.PAST_LAST)) {
                return translatedProperties;
            }
            ImmutableList.Builder localProperties = ImmutableList.builder();
            if (!node.getPrePartitionedInputs().isEmpty()) {
                GroupingProperty prePartitionedProperty = new GroupingProperty(node.getPrePartitionedInputs());
                for (LocalProperty<Symbol> localProperty : translatedProperties.getLocalProperties()) {
                    if (!prePartitionedProperty.isSimplifiedBy(localProperty)) break;
                    localProperties.add(localProperty);
                }
            }
            if (!node.getPartitionBy().isEmpty()) {
                localProperties.add((Object)new GroupingProperty(node.getPartitionBy()));
            }
            if (node.getRowsPerMatch().isOneRow() || node.getSkipToPosition() == SkipToPosition.PAST_LAST) {
                ImmutableSet outputs = ImmutableSet.copyOf(node.getOutputSymbols());
                orderingScheme.ifPresent(arg_0 -> Visitor.lambda$visitPatternRecognition$5((Set)outputs, localProperties, arg_0));
            }
            return ActualProperties.builderFrom(translatedProperties).local((List<? extends LocalProperty<Symbol>>)localProperties.build()).build();
        }

        @Override
        public ActualProperties visitTableFunction(TableFunctionNode node, List<ActualProperties> inputProperties) {
            throw new IllegalStateException(String.format("Unexpected node: TableFunctionNode (%s)", node.getName()));
        }

        @Override
        public ActualProperties visitTableFunctionProcessor(TableFunctionProcessorNode node, List<ActualProperties> inputProperties) {
            List partitionBy;
            ImmutableList.Builder localProperties = ImmutableList.builder();
            if (node.getSource().isPresent()) {
                ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
                if (!node.getPrePartitioned().isEmpty()) {
                    GroupingProperty prePartitionedProperty = new GroupingProperty(node.getPrePartitioned());
                    for (LocalProperty<Symbol> localProperty : properties.getLocalProperties()) {
                        if (!prePartitionedProperty.isSimplifiedBy(localProperty)) break;
                        localProperties.add(localProperty);
                    }
                }
            }
            if (!(partitionBy = node.getSpecification().map(DataOrganizationSpecification::getPartitionBy).orElse((List)ImmutableList.of())).isEmpty()) {
                localProperties.add((Object)new GroupingProperty((Collection)partitionBy));
            }
            return ActualProperties.builder().local((List<? extends LocalProperty<Symbol>>)localProperties.build()).build().translate(symbol -> node.getOutputSymbols().contains(symbol) ? Optional.of(symbol) : Optional.empty());
        }

        @Override
        public ActualProperties visitGroupId(GroupIdNode node, List<ActualProperties> inputProperties) {
            HashMap<Symbol, Symbol> inputToOutputMappings = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, Symbol> setMapping : node.getGroupingColumns().entrySet()) {
                if (!node.getCommonGroupingColumns().contains(setMapping.getKey())) continue;
                inputToOutputMappings.putIfAbsent(setMapping.getValue(), setMapping.getKey());
            }
            for (Symbol argument : node.getAggregationArguments()) {
                inputToOutputMappings.putIfAbsent(argument, argument);
            }
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translate(column -> Optional.ofNullable((Symbol)inputToOutputMappings.get(column)));
        }

        @Override
        public ActualProperties visitAggregation(AggregationNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ActualProperties translated = properties.translate(symbol -> node.getGroupingKeys().contains(symbol) ? Optional.of(symbol) : Optional.empty());
            return ActualProperties.builderFrom(translated).local(LocalProperties.grouped(node.getGroupingKeys())).build();
        }

        @Override
        public ActualProperties visitRowNumber(RowNumberNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitTopNRanking(TopNRankingNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ImmutableList.Builder localProperties = ImmutableList.builder();
            localProperties.add((Object)new GroupingProperty(node.getPartitionBy()));
            localProperties.addAll(node.getOrderingScheme().toLocalProperties());
            return ActualProperties.builderFrom(properties).local((List<? extends LocalProperty<Symbol>>)localProperties.build()).build();
        }

        @Override
        public ActualProperties visitTopN(TopNNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            return ActualProperties.builderFrom(properties).local(node.getOrderingScheme().toLocalProperties()).build();
        }

        @Override
        public ActualProperties visitSort(SortNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            return ActualProperties.builderFrom(properties).local(node.getOrderingScheme().toLocalProperties()).build();
        }

        @Override
        public ActualProperties visitLimit(LimitNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitDistinctLimit(DistinctLimitNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            return ActualProperties.builderFrom(properties).local(LocalProperties.grouped(node.getDistinctSymbols())).build();
        }

        @Override
        public ActualProperties visitStatisticsWriterNode(StatisticsWriterNode node, List<ActualProperties> context) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSinglePartition()).build();
        }

        @Override
        public ActualProperties visitTableFinish(TableFinishNode node, List<ActualProperties> inputProperties) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSinglePartition()).build();
        }

        @Override
        public ActualProperties visitTableDelete(TableDeleteNode node, List<ActualProperties> context) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSinglePartition()).build();
        }

        @Override
        public ActualProperties visitTableUpdate(TableUpdateNode node, List<ActualProperties> context) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSinglePartition()).build();
        }

        @Override
        public ActualProperties visitTableExecute(TableExecuteNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            if (properties.isCoordinatorOnly()) {
                return ActualProperties.builder().global(ActualProperties.Global.coordinatorSinglePartition()).build();
            }
            return ActualProperties.builder().global(properties.isSingleNode() ? ActualProperties.Global.singlePartition() : ActualProperties.Global.arbitraryPartition()).build();
        }

        @Override
        public ActualProperties visitSimpleTableExecuteNode(SimpleTableExecuteNode node, List<ActualProperties> inputProperties) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSinglePartition()).build();
        }

        @Override
        public ActualProperties visitMergeWriter(MergeWriterNode node, List<ActualProperties> inputProperties) {
            return this.visitPartitionedWriter(inputProperties);
        }

        @Override
        public ActualProperties visitMergeProcessor(MergeProcessorNode node, List<ActualProperties> inputProperties) {
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translate(symbol -> Optional.empty());
        }

        @Override
        public ActualProperties visitJoin(JoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties buildProperties = inputProperties.get(1);
            boolean unordered = PropertyDerivations.spillPossible(this.session, node.getType());
            return switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case JoinType.INNER -> {
                    probeProperties = probeProperties.translate(column -> PropertyDerivations.filterOrRewrite(node.getOutputSymbols(), node.getCriteria(), column));
                    buildProperties = buildProperties.translate(column -> PropertyDerivations.filterOrRewrite(node.getOutputSymbols(), node.getCriteria(), column));
                    HashMap<Symbol, NullableValue> constants = new HashMap<Symbol, NullableValue>();
                    constants.putAll(probeProperties.getConstants());
                    constants.putAll(buildProperties.getConstants());
                    if (node.isCrossJoin()) {
                        yield ActualProperties.builder().global(probeProperties).local((List<? extends LocalProperty<Symbol>>)ImmutableList.of()).constants(constants).build();
                    }
                    yield ActualProperties.builderFrom(probeProperties).constants(constants).unordered(unordered).build();
                }
                case JoinType.LEFT -> ActualProperties.builderFrom(probeProperties.translate(column -> PropertyDerivations.filterIfMissing(node.getOutputSymbols(), column))).unordered(unordered).build();
                case JoinType.RIGHT -> ActualProperties.builderFrom(buildProperties.translate(column -> PropertyDerivations.filterIfMissing(node.getOutputSymbols(), column))).local((List<? extends LocalProperty<Symbol>>)ImmutableList.of()).unordered(true).build();
                case JoinType.FULL -> ActualProperties.builder().global(probeProperties.isSingleNode() ? ActualProperties.Global.singlePartition() : ActualProperties.Global.arbitraryPartition()).build();
            };
        }

        @Override
        public ActualProperties visitSemiJoin(SemiJoinNode node, List<ActualProperties> inputProperties) {
            return inputProperties.get(0);
        }

        @Override
        public ActualProperties visitSpatialJoin(SpatialJoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties buildProperties = inputProperties.get(1);
            return switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case SpatialJoinNode.Type.INNER -> {
                    probeProperties = probeProperties.translate(column -> PropertyDerivations.filterIfMissing(node.getOutputSymbols(), column));
                    buildProperties = buildProperties.translate(column -> PropertyDerivations.filterIfMissing(node.getOutputSymbols(), column));
                    HashMap<Symbol, NullableValue> constants = new HashMap<Symbol, NullableValue>();
                    constants.putAll(probeProperties.getConstants());
                    constants.putAll(buildProperties.getConstants());
                    yield ActualProperties.builderFrom(probeProperties).constants(constants).build();
                }
                case SpatialJoinNode.Type.LEFT -> ActualProperties.builderFrom(probeProperties.translate(column -> PropertyDerivations.filterIfMissing(node.getOutputSymbols(), column))).build();
            };
        }

        @Override
        public ActualProperties visitIndexJoin(IndexJoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties indexProperties = inputProperties.get(1);
            return switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case IndexJoinNode.Type.INNER -> ActualProperties.builderFrom(probeProperties).constants((Map<Symbol, NullableValue>)ImmutableMap.builder().putAll(probeProperties.getConstants()).putAll(indexProperties.getConstants()).buildOrThrow()).build();
                case IndexJoinNode.Type.SOURCE_OUTER -> ActualProperties.builderFrom(probeProperties).constants(probeProperties.getConstants()).build();
            };
        }

        @Override
        public ActualProperties visitDynamicFilterSource(DynamicFilterSourceNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitIndexSource(IndexSourceNode node, List<ActualProperties> context) {
            return ActualProperties.builder().global(ActualProperties.Global.singlePartition()).build();
        }

        public static Map<Symbol, Symbol> exchangeInputToOutput(ExchangeNode node, int sourceIndex) {
            List<Symbol> inputSymbols = node.getInputs().get(sourceIndex);
            HashMap<Symbol, Symbol> inputToOutput = new HashMap<Symbol, Symbol>();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                inputToOutput.put(inputSymbols.get(i), node.getOutputSymbols().get(i));
            }
            return inputToOutput;
        }

        @Override
        public ActualProperties visitExchange(ExchangeNode node, List<ActualProperties> inputProperties) {
            Preconditions.checkArgument((node.getScope() != ExchangeNode.Scope.REMOTE || inputProperties.stream().noneMatch(ActualProperties::isNullsAndAnyReplicated) ? 1 : 0) != 0, (Object)"Null-and-any replicated inputs should not be remotely exchanged");
            Sets.SetView entries = null;
            for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                Map<Symbol, Symbol> inputToOutput = Visitor.exchangeInputToOutput(node, sourceIndex);
                ActualProperties translated = inputProperties.get(sourceIndex).translate(symbol -> Optional.ofNullable((Symbol)inputToOutput.get(symbol)));
                entries = entries == null ? translated.getConstants().entrySet() : Sets.intersection(entries, translated.getConstants().entrySet());
            }
            Preconditions.checkState((entries != null ? 1 : 0) != 0);
            Map<Symbol, NullableValue> constants = entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ImmutableList.Builder localProperties = ImmutableList.builder();
            node.getOrderingScheme().ifPresent(orderingScheme -> localProperties.addAll(orderingScheme.toLocalProperties()));
            if (node.getScope() == ExchangeNode.Scope.LOCAL) {
                ActualProperties inputProperty;
                if (inputProperties.size() == 1 && (inputProperty = inputProperties.get(0)).isEffectivelySinglePartition() && node.getOrderingScheme().isEmpty() && !inputProperty.getLocalProperties().isEmpty()) {
                    boolean propagateLocalProperties;
                    Verify.verify((node.getInputs().size() == 1 ? 1 : 0) != 0);
                    Verify.verify((node.getSources().size() == 1 ? 1 : 0) != 0);
                    Map<Symbol, Symbol> inputToOutput = Visitor.exchangeInputToOutput(node, 0);
                    List inputLocalProperties = LocalProperties.translate(inputProperty.getLocalProperties(), symbol -> Optional.ofNullable((Symbol)inputToOutput.get(symbol)));
                    boolean bl = propagateLocalProperties = !inputLocalProperties.isEmpty() && StreamPropertyDerivations.isLocalExchangesSourceSingleStreamDistributed(node, this.plannerContext.getMetadata(), this.session);
                    if (propagateLocalProperties) {
                        localProperties.addAll(inputLocalProperties);
                    }
                }
                ActualProperties.Builder builder = ActualProperties.builder();
                builder.local((List<? extends LocalProperty<Symbol>>)localProperties.build());
                builder.constants(constants);
                if (inputProperties.stream().anyMatch(ActualProperties::isCoordinatorOnly)) {
                    builder.global(ActualProperties.Global.coordinatorSinglePartition());
                } else if (inputProperties.stream().anyMatch(ActualProperties::isSingleNode)) {
                    builder.global(ActualProperties.Global.singlePartition());
                }
                return builder.build();
            }
            return switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case ExchangeNode.Type.GATHER -> ActualProperties.builder().global(node.getPartitioningScheme().getPartitioning().getHandle().isCoordinatorOnly() ? ActualProperties.Global.coordinatorSinglePartition() : ActualProperties.Global.singlePartition()).local((List<? extends LocalProperty<Symbol>>)localProperties.build()).constants(constants).build();
                case ExchangeNode.Type.REPARTITION -> ActualProperties.builder().global(ActualProperties.Global.partitionedOn(node.getPartitioningScheme().getPartitioning()).withReplicatedNulls(node.getPartitioningScheme().isReplicateNullsAndAny())).constants(constants).build();
                case ExchangeNode.Type.REPLICATE -> ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).constants(constants).build();
            };
        }

        @Override
        public ActualProperties visitFilter(FilterNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.getExtractionResult(this.plannerContext, this.session, node.getPredicate());
            HashMap<Symbol, NullableValue> constants = new HashMap<Symbol, NullableValue>(properties.getConstants());
            constants.putAll((Map)TupleDomain.extractFixedValues(decomposedPredicate.getTupleDomain()).orElse(ImmutableMap.of()));
            return ActualProperties.builderFrom(properties).constants(constants).build();
        }

        @Override
        public ActualProperties visitProject(ProjectNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            Map<Symbol, Symbol> identities = Visitor.computeIdentityTranslations(node.getAssignments().getMap());
            ActualProperties translatedProperties = properties.translate(column -> Optional.ofNullable((Symbol)identities.get(column)), expression -> PropertyDerivations.rewriteExpression(node.getAssignments().getMap(), expression));
            HashMap<Symbol, NullableValue> constants = new HashMap<Symbol, NullableValue>();
            for (Map.Entry<Symbol, Expression> assignment : node.getAssignments().entrySet()) {
                Expression expression2 = assignment.getValue();
                Type type = expression2.type();
                IrExpressionInterpreter optimizer = new IrExpressionInterpreter(expression2, this.plannerContext, this.session);
                Object value = optimizer.optimize(NoOpSymbolResolver.INSTANCE);
                if (value instanceof SymbolReference) {
                    Symbol symbol = Symbol.from((SymbolReference)value);
                    NullableValue existingConstantValue = (NullableValue)constants.get(symbol);
                    if (existingConstantValue == null) continue;
                    constants.put(assignment.getKey(), new NullableValue(type, value));
                    continue;
                }
                if (value instanceof Expression) continue;
                constants.put(assignment.getKey(), new NullableValue(type, value));
            }
            constants.putAll(translatedProperties.getConstants());
            return ActualProperties.builderFrom(translatedProperties).constants(constants).build();
        }

        @Override
        public ActualProperties visitRefreshMaterializedView(RefreshMaterializedViewNode node, List<ActualProperties> inputProperties) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSinglePartition()).build();
        }

        @Override
        public ActualProperties visitTableWriter(TableWriterNode node, List<ActualProperties> inputProperties) {
            return this.visitPartitionedWriter(inputProperties);
        }

        private ActualProperties visitPartitionedWriter(List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            if (properties.isCoordinatorOnly()) {
                return ActualProperties.builder().global(ActualProperties.Global.coordinatorSinglePartition()).build();
            }
            return ActualProperties.builder().global(properties.isSingleNode() ? ActualProperties.Global.singlePartition() : ActualProperties.Global.arbitraryPartition()).build();
        }

        @Override
        public ActualProperties visitSample(SampleNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitUnnest(UnnestNode node, List<ActualProperties> inputProperties) {
            ImmutableSet passThroughInputs = ImmutableSet.copyOf(node.getReplicateSymbols());
            ActualProperties translatedProperties = ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translate(arg_0 -> Visitor.lambda$visitUnnest$22((Set)passThroughInputs, arg_0));
            return switch (node.getJoinType()) {
                default -> throw new MatchException(null, null);
                case JoinType.INNER, JoinType.LEFT -> translatedProperties;
                case JoinType.RIGHT, JoinType.FULL -> ActualProperties.builderFrom(translatedProperties).local((List<? extends LocalProperty<Symbol>>)ImmutableList.of()).build();
            };
        }

        @Override
        public ActualProperties visitValues(ValuesNode node, List<ActualProperties> context) {
            return ActualProperties.builder().global(ActualProperties.Global.singlePartition()).build();
        }

        @Override
        public ActualProperties visitTableScan(TableScanNode node, List<ActualProperties> inputProperties) {
            TableProperties layout = this.plannerContext.getMetadata().getTableProperties(this.session, node.getTable());
            ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            ActualProperties.Builder properties = ActualProperties.builder();
            HashMap globalConstants = new HashMap();
            ((Map)TupleDomain.extractFixedValues(layout.getPredicate()).orElse(ImmutableMap.of())).entrySet().stream().filter(entry -> !((NullableValue)entry.getValue()).isNull()).forEach(entry -> globalConstants.put((ColumnHandle)entry.getKey(), (NullableValue)entry.getValue()));
            Map<Symbol, NullableValue> symbolConstants = globalConstants.entrySet().stream().filter(arg_0 -> Visitor.lambda$visitTableScan$25((Map)assignments, arg_0)).collect(Collectors.toMap(arg_0 -> Visitor.lambda$visitTableScan$26((Map)assignments, arg_0), Map.Entry::getValue));
            properties.constants(symbolConstants);
            properties.global(this.deriveGlobalProperties(node, layout, (Map<ColumnHandle, Symbol>)assignments));
            ImmutableList constantAppendedLocalProperties = ImmutableList.builder().addAll(globalConstants.keySet().stream().map(ConstantProperty::new).iterator()).addAll(layout.getLocalProperties()).build();
            properties.local(LocalProperties.translate(constantAppendedLocalProperties, arg_0 -> Visitor.lambda$visitTableScan$27((Map)assignments, arg_0)));
            return properties.build();
        }

        private ActualProperties.Global deriveGlobalProperties(TableScanNode node, TableProperties layout, Map<ColumnHandle, Symbol> assignments) {
            if (layout.getTablePartitioning().isPresent() && node.isUseConnectorNodePartitioning()) {
                TableProperties.TablePartitioning tablePartitioning = layout.getTablePartitioning().get();
                if (assignments.keySet().containsAll(tablePartitioning.getPartitioningColumns())) {
                    List arguments = (List)tablePartitioning.getPartitioningColumns().stream().map(assignments::get).collect(ImmutableList.toImmutableList());
                    return ActualProperties.Global.partitionedOn(tablePartitioning.getPartitioningHandle(), arguments);
                }
            }
            return ActualProperties.Global.arbitraryPartition();
        }

        private static Map<Symbol, Symbol> computeIdentityTranslations(Map<Symbol, Expression> assignments) {
            HashMap<Symbol, Symbol> inputToOutput = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
                if (!(assignment.getValue() instanceof SymbolReference)) continue;
                inputToOutput.put(Symbol.from(assignment.getValue()), assignment.getKey());
            }
            return inputToOutput;
        }

        private static /* synthetic */ Optional lambda$visitTableScan$27(Map assignments, ColumnHandle column) {
            return Optional.ofNullable((Symbol)assignments.get(column));
        }

        private static /* synthetic */ Symbol lambda$visitTableScan$26(Map assignments, Map.Entry entry) {
            return (Symbol)assignments.get(entry.getKey());
        }

        private static /* synthetic */ boolean lambda$visitTableScan$25(Map assignments, Map.Entry entry) {
            return assignments.containsKey(entry.getKey());
        }

        private static /* synthetic */ Optional lambda$visitUnnest$22(Set passThroughInputs, Symbol column) {
            if (passThroughInputs.contains(column)) {
                return Optional.of(column);
            }
            return Optional.empty();
        }

        private static /* synthetic */ void lambda$visitPatternRecognition$5(Set outputs, ImmutableList.Builder localProperties, OrderingScheme ordering) {
            ordering.toLocalProperties().stream().filter(property -> outputs.containsAll(property.getColumns())).forEach(arg_0 -> ((ImmutableList.Builder)localProperties).add(arg_0));
        }
    }
}

