/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SimplePlanRewriter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class TransformQuantifiedComparisonApplyToCorrelatedJoin
implements PlanOptimizer {
    private final Metadata metadata;

    public TransformQuantifiedComparisonApplyToCorrelatedJoin(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(context.idAllocator(), context.symbolAllocator(), this.metadata), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<PlanNode> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final Metadata metadata;

        public Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Metadata metadata) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            if (node.getSubqueryAssignments().size() != 1) {
                return context.defaultRewrite(node);
            }
            ApplyNode.SetExpression expression = (ApplyNode.SetExpression)Iterables.getOnlyElement(node.getSubqueryAssignments().values());
            if (expression instanceof ApplyNode.QuantifiedComparison) {
                ApplyNode.QuantifiedComparison comparison = (ApplyNode.QuantifiedComparison)expression;
                return this.rewriteQuantifiedApplyNode(node, comparison, context);
            }
            return context.defaultRewrite(node);
        }

        private PlanNode rewriteQuantifiedApplyNode(ApplyNode node, ApplyNode.QuantifiedComparison quantifiedComparison, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            PlanNode subqueryPlan = context.rewrite(node.getSubquery());
            Symbol outputColumn = (Symbol)Iterables.getOnlyElement(subqueryPlan.getOutputSymbols());
            Type outputColumnType = outputColumn.getType();
            Preconditions.checkState((boolean)outputColumnType.isOrderable(), (Object)"Subquery result type must be orderable");
            Symbol minValue = this.symbolAllocator.newSymbol("min", outputColumnType);
            Symbol maxValue = this.symbolAllocator.newSymbol("max", outputColumnType);
            Symbol countAllValue = this.symbolAllocator.newSymbol("count_all", (Type)BigintType.BIGINT);
            Symbol countNonNullValue = this.symbolAllocator.newSymbol("count_non_null", (Type)BigintType.BIGINT);
            ImmutableList outputColumnReferences = ImmutableList.of((Object)outputColumn.toSymbolReference());
            subqueryPlan = AggregationNode.singleAggregation(this.idAllocator.getNextId(), subqueryPlan, (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of((Object)minValue, (Object)new AggregationNode.Aggregation(this.metadata.resolveBuiltinFunction("min", TypeSignatureProvider.fromTypes(outputColumnType)), (List<Expression>)outputColumnReferences, false, Optional.empty(), Optional.empty(), Optional.empty()), (Object)maxValue, (Object)new AggregationNode.Aggregation(this.metadata.resolveBuiltinFunction("max", TypeSignatureProvider.fromTypes(outputColumnType)), (List<Expression>)outputColumnReferences, false, Optional.empty(), Optional.empty(), Optional.empty()), (Object)countAllValue, (Object)new AggregationNode.Aggregation(this.metadata.resolveBuiltinFunction("count", Collections.emptyList()), (List<Expression>)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty()), (Object)countNonNullValue, (Object)new AggregationNode.Aggregation(this.metadata.resolveBuiltinFunction("count", TypeSignatureProvider.fromTypes(outputColumnType)), (List<Expression>)outputColumnReferences, false, Optional.empty(), Optional.empty(), Optional.empty())), AggregationNode.globalAggregation());
            CorrelatedJoinNode join = new CorrelatedJoinNode(node.getId(), context.rewrite(node.getInput()), subqueryPlan, node.getCorrelation(), JoinType.INNER, BooleanLiteral.TRUE_LITERAL, node.getOriginSubquery());
            Expression valueComparedToSubquery = this.rewriteUsingBounds(quantifiedComparison, minValue, maxValue, countAllValue, countNonNullValue);
            Symbol quantifiedComparisonSymbol = (Symbol)Iterables.getOnlyElement(node.getSubqueryAssignments().keySet());
            return this.projectExpressions(join, Assignments.of(quantifiedComparisonSymbol, valueComparedToSubquery));
        }

        public Expression rewriteUsingBounds(ApplyNode.QuantifiedComparison quantifiedComparison, Symbol minValue, Symbol maxValue, Symbol countAllValue, Symbol countNonNullValue) {
            Function<List, Expression> quantifier;
            Constant emptySetResult;
            if (quantifiedComparison.quantifier() == ApplyNode.Quantifier.ALL) {
                emptySetResult = BooleanLiteral.TRUE_LITERAL;
                quantifier = expressions -> IrUtils.combineConjuncts(expressions);
            } else {
                emptySetResult = BooleanLiteral.FALSE_LITERAL;
                quantifier = expressions -> IrUtils.combineDisjuncts(expressions);
            }
            Expression comparisonWithExtremeValue = this.getBoundComparisons(quantifiedComparison, minValue, maxValue);
            return new SimpleCaseExpression(countAllValue.toSymbolReference(), (List<WhenClause>)ImmutableList.of((Object)new WhenClause(new Constant((Type)BigintType.BIGINT, 0L), emptySetResult)), Optional.of(quantifier.apply((List)ImmutableList.of((Object)comparisonWithExtremeValue, (Object)new SearchedCaseExpression((List<WhenClause>)ImmutableList.of((Object)new WhenClause(new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, countAllValue.toSymbolReference(), countNonNullValue.toSymbolReference()), new Constant((Type)BooleanType.BOOLEAN, null))), Optional.of(emptySetResult))))));
        }

        private Expression getBoundComparisons(ApplyNode.QuantifiedComparison quantifiedComparison, Symbol minValue, Symbol maxValue) {
            if (Rewriter.mapOperator(quantifiedComparison) == ComparisonExpression.Operator.EQUAL && quantifiedComparison.quantifier() == ApplyNode.Quantifier.ALL) {
                return IrUtils.combineConjuncts(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, minValue.toSymbolReference(), maxValue.toSymbolReference()), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, quantifiedComparison.value().toSymbolReference(), maxValue.toSymbolReference()));
            }
            if (EnumSet.of(ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL).contains((Object)Rewriter.mapOperator(quantifiedComparison))) {
                Symbol boundValue = Rewriter.shouldCompareValueWithLowerBound(quantifiedComparison) ? minValue : maxValue;
                return new ComparisonExpression(Rewriter.mapOperator(quantifiedComparison), quantifiedComparison.value().toSymbolReference(), boundValue.toSymbolReference());
            }
            throw new IllegalArgumentException("Unsupported quantified comparison: " + String.valueOf(quantifiedComparison));
        }

        private static ComparisonExpression.Operator mapOperator(ApplyNode.QuantifiedComparison quantifiedComparison) {
            return switch (quantifiedComparison.operator()) {
                default -> throw new MatchException(null, null);
                case ApplyNode.Operator.EQUAL -> ComparisonExpression.Operator.EQUAL;
                case ApplyNode.Operator.NOT_EQUAL -> ComparisonExpression.Operator.NOT_EQUAL;
                case ApplyNode.Operator.LESS_THAN -> ComparisonExpression.Operator.LESS_THAN;
                case ApplyNode.Operator.LESS_THAN_OR_EQUAL -> ComparisonExpression.Operator.LESS_THAN_OR_EQUAL;
                case ApplyNode.Operator.GREATER_THAN -> ComparisonExpression.Operator.GREATER_THAN;
                case ApplyNode.Operator.GREATER_THAN_OR_EQUAL -> ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL;
            };
        }

        private static boolean shouldCompareValueWithLowerBound(ApplyNode.QuantifiedComparison quantifiedComparison) {
            return switch (quantifiedComparison.quantifier()) {
                default -> throw new MatchException(null, null);
                case ApplyNode.Quantifier.ALL -> {
                    switch (Rewriter.mapOperator(quantifiedComparison)) {
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            yield true;
                        }
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: {
                            yield false;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)Rewriter.mapOperator(quantifiedComparison)));
                }
                case ApplyNode.Quantifier.ANY, ApplyNode.Quantifier.SOME -> {
                    switch (Rewriter.mapOperator(quantifiedComparison)) {
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            yield false;
                        }
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: {
                            yield true;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)Rewriter.mapOperator(quantifiedComparison)));
                }
            };
        }

        private ProjectNode projectExpressions(PlanNode input, Assignments subqueryAssignments) {
            Assignments assignments = Assignments.builder().putIdentities(input.getOutputSymbols()).putAll(subqueryAssignments).build();
            return new ProjectNode(this.idAllocator.getNextId(), input, assignments);
        }
    }
}

