/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import java.util.Optional;

public class TableExecuteStructureValidator
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, PlannerContext plannerContext, WarningCollector warningCollector) {
        Optional tableExecuteNode = PlanNodeSearcher.searchFrom(planNode).where(node -> node instanceof TableExecuteNode).findFirst();
        if (tableExecuteNode.isEmpty()) {
            return;
        }
        PlanNodeSearcher.searchFrom(planNode).findAll().forEach(node -> {
            if (!this.isAllowedNode((PlanNode)node)) {
                throw new IllegalStateException("Unexpected " + node.getClass().getSimpleName() + " found in plan; probably connector was not able to handle provided WHERE expression");
            }
        });
    }

    private boolean isAllowedNode(PlanNode node) {
        return node instanceof TableScanNode || node instanceof ProjectNode || node instanceof TableExecuteNode || node instanceof OutputNode || node instanceof ExchangeNode || node instanceof TableFinishNode;
    }
}

