/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.SimplePlanVisitor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.type.FunctionType;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;

public final class TypeValidator
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, PlannerContext plannerContext, WarningCollector warningCollector) {
        plan.accept(new Visitor(), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private Visitor() {
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            AggregationNode.Step step = node.getStep();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                switch (step) {
                    case SINGLE: {
                        this.checkSignature(symbol, aggregation.getResolvedFunction().getSignature());
                        this.checkCall(symbol, aggregation.getResolvedFunction().getSignature(), aggregation.getArguments());
                        break;
                    }
                    case FINAL: {
                        this.checkSignature(symbol, aggregation.getResolvedFunction().getSignature());
                        break;
                    }
                }
            }
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            this.checkWindowFunctions(node.getWindowFunctions());
            return null;
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                Type expectedType = entry.getKey().getType();
                Expression expression = entry.getValue();
                if (expression instanceof SymbolReference) {
                    SymbolReference symbolReference = (SymbolReference)expression;
                    Symbol symbol = Symbol.from(symbolReference);
                    this.verifyTypeSignature(entry.getKey(), expectedType, symbol.getType());
                    continue;
                }
                Type actualType = entry.getValue().type();
                this.verifyTypeSignature(entry.getKey(), expectedType, actualType);
            }
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            ListMultimap<Symbol, Symbol> symbolMapping = node.getSymbolMapping();
            for (Symbol keySymbol : symbolMapping.keySet()) {
                List valueSymbols = symbolMapping.get((Object)keySymbol);
                Type expectedType = keySymbol.getType();
                for (Symbol valueSymbol : valueSymbols) {
                    this.verifyTypeSignature(keySymbol, expectedType, valueSymbol.getType());
                }
            }
            return null;
        }

        private void checkWindowFunctions(Map<Symbol, WindowNode.Function> functions) {
            functions.forEach((symbol, function) -> {
                this.checkSignature((Symbol)symbol, function.getResolvedFunction().getSignature());
                this.checkCall((Symbol)symbol, function.getResolvedFunction().getSignature(), function.getArguments());
            });
        }

        private void checkSignature(Symbol symbol, BoundSignature signature) {
            Type expectedType = symbol.getType();
            Type actualType = signature.getReturnType();
            this.verifyTypeSignature(symbol, expectedType, actualType);
        }

        private void checkCall(Symbol symbol, BoundSignature signature, List<Expression> arguments) {
            Type expectedType = symbol.getType();
            Type actualType = signature.getReturnType();
            this.verifyTypeSignature(symbol, expectedType, actualType);
            Preconditions.checkArgument((signature.getArgumentTypes().size() == arguments.size() ? 1 : 0) != 0, (String)"expected %s arguments, but found %s arguments", (int)signature.getArgumentTypes().size(), (int)arguments.size());
            for (int i = 0; i < arguments.size(); ++i) {
                Type expectedTypeSignature = (Type)signature.getArgumentTypes().get(i);
                if (expectedTypeSignature instanceof FunctionType) continue;
                Type actualTypeSignature = arguments.get(i).type();
                this.verifyTypeSignature(symbol, expectedTypeSignature, actualTypeSignature);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void verifyTypeSignature(Symbol symbol, Type expected, Type actual) {
            if (actual instanceof RowType) {
                RowType actualRowType = (RowType)actual;
                if (expected instanceof RowType) {
                    RowType expectedRowType = (RowType)expected;
                    List<Type> actualFieldTypes = actualRowType.getFields().stream().map(RowType.Field::getType).toList();
                    List<Type> expectedFieldType = expectedRowType.getFields().stream().map(RowType.Field::getType).toList();
                    Preconditions.checkArgument((boolean)expectedFieldType.equals(actualFieldTypes), (String)"type of symbol '%s' is expected to be %s, but the actual type is %s", (Object)symbol.getName(), (Object)expected, (Object)actual);
                    return;
                }
            }
            if (actual instanceof UnknownType) return;
            Preconditions.checkArgument((boolean)expected.equals((Object)actual), (String)"type of symbol '%s' is expected to be %s, but the actual type is %s", (Object)symbol.getName(), (Object)expected, (Object)actual);
        }
    }
}

