/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.type.FunctionType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LambdaDefinitionExpression
extends RowExpression {
    private final List<Symbol> arguments;
    private final RowExpression body;

    @JsonCreator
    public LambdaDefinitionExpression(@JsonProperty List<Symbol> arguments, @JsonProperty RowExpression body) {
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
        this.body = Objects.requireNonNull(body, "body is null");
    }

    @JsonProperty
    public List<Symbol> getArguments() {
        return this.arguments;
    }

    @JsonProperty
    public RowExpression getBody() {
        return this.body;
    }

    @Override
    public Type getType() {
        return new FunctionType(this.arguments.stream().map(Symbol::getType).toList(), this.body.getType());
    }

    @Override
    public String toString() {
        return "(" + this.arguments.stream().map(Symbol::getName).collect(Collectors.joining(", ")) + ") -> " + String.valueOf(this.body);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaDefinitionExpression that = (LambdaDefinitionExpression)o;
        return Objects.equals(this.arguments, that.arguments) && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arguments, this.body);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLambda(this, context);
    }
}

