/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Key;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.execution.FailureInjector;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.SessionPropertyManager;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.ErrorType;
import io.trino.spi.Plugin;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.Plan;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Statement;
import io.trino.testing.DirectTrinoClient;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProviderManager;
import io.trino.transaction.TransactionManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;

public final class StandaloneQueryRunner
implements QueryRunner {
    private final Session defaultSession;
    private final TestingTrinoServer server;
    private final DirectTrinoClient trinoClient;
    private final InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicInteger concurrentQueries = new AtomicInteger();
    private volatile boolean spansValid = true;

    public StandaloneQueryRunner(Session defaultSession) {
        this(defaultSession, builder -> {});
    }

    public StandaloneQueryRunner(Session defaultSession, Consumer<TestingTrinoServer.Builder> serverProcessor) {
        this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        TestingTrinoServer.Builder builder = TestingTrinoServer.builder().setSpanProcessor(SimpleSpanProcessor.create((SpanExporter)this.spanExporter)).setProperties((Map<String, String>)ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"node-scheduler.min-candidates", (Object)"1").buildOrThrow());
        serverProcessor.accept(builder);
        this.server = builder.build();
        this.trinoClient = new DirectTrinoClient(this.server.getDispatchManager(), this.server.getQueryManager(), (DirectExchangeClientSupplier)this.server.getInstance(Key.get(DirectExchangeClientSupplier.class)), (BlockEncodingSerde)this.server.getInstance(Key.get(BlockEncodingSerde.class)));
    }

    @Override
    public List<SpanData> getSpans() {
        Preconditions.checkState((boolean)this.spansValid, (Object)"No valid spans, queries were executing concurrently");
        return this.spanExporter.getFinishedSpanItems();
    }

    @Override
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return this.executeInternal(session, sql).result();
    }

    @Override
    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql) {
        DirectTrinoClient.Result result = this.executeInternal(session, sql);
        return new QueryRunner.MaterializedResultWithPlan(result.queryId(), this.server.getQueryPlan(result.queryId()), result.result());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectTrinoClient.Result executeInternal(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            DirectTrinoClient.Result result;
            this.spansValid = this.concurrentQueries.incrementAndGet() == 1;
            try {
                this.spanExporter.reset();
                result = this.trinoClient.execute(session, sql);
                this.concurrentQueries.decrementAndGet();
            }
            catch (Throwable throwable) {
                try {
                    this.concurrentQueries.decrementAndGet();
                    throw throwable;
                }
                catch (Throwable e) {
                    e.addSuppressed(new Exception("SQL: " + sql));
                    throw e;
                }
            }
            return result;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plan createPlan(Session session, String sql) {
        this.getTransactionManager().getTransactionInfo(session.getRequiredTransactionId());
        this.spansValid = this.concurrentQueries.incrementAndGet() == 1;
        try {
            this.spanExporter.reset();
            Statement statement = ((SqlParser)this.server.getInstance(Key.get(SqlParser.class))).createStatement(sql);
            Plan plan = this.server.getQueryExplainer().getLogicalPlan(session, statement, (List<Expression>)ImmutableList.of(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
            return plan;
        }
        finally {
            this.concurrentQueries.decrementAndGet();
        }
    }

    @Override
    public void close() {
        try {
            this.server.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    @Override
    public Session getDefaultSession() {
        return this.defaultSession;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.server.getTransactionManager();
    }

    @Override
    public PlannerContext getPlannerContext() {
        return this.server.getPlannerContext();
    }

    @Override
    public QueryExplainer getQueryExplainer() {
        return this.server.getQueryExplainer();
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.server.getSessionPropertyManager();
    }

    @Override
    public SplitManager getSplitManager() {
        return this.server.getSplitManager();
    }

    @Override
    public PageSourceManager getPageSourceManager() {
        return this.server.getPageSourceManager();
    }

    @Override
    public NodePartitioningManager getNodePartitioningManager() {
        return this.server.getNodePartitioningManager();
    }

    @Override
    public StatsCalculator getStatsCalculator() {
        return this.server.getStatsCalculator();
    }

    @Override
    public TestingGroupProviderManager getGroupProvider() {
        return this.server.getGroupProvider();
    }

    @Override
    public TestingAccessControlManager getAccessControl() {
        return this.server.getAccessControl();
    }

    @Override
    public TestingTrinoServer getCoordinator() {
        return this.server;
    }

    @Override
    public void installPlugin(Plugin plugin) {
        this.server.installPlugin(plugin);
    }

    @Override
    public void addFunctions(FunctionBundle functionBundle) {
        this.server.addFunctions(functionBundle);
    }

    @Override
    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        this.server.createCatalog(catalogName, connectorName, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List list = this.inTransaction(session, transactionSession -> this.server.getPlannerContext().getMetadata().listTables((Session)transactionSession, new QualifiedTablePrefix(catalog, schema)));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.inTransaction(session, transactionSession -> MetadataUtil.tableExists(this.server.getPlannerContext().getMetadata(), transactionSession, table));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    @Override
    public void injectTaskFailure(String traceToken, int stageId, int partitionId, int attemptId, FailureInjector.InjectedFailureType injectionType, Optional<ErrorType> errorType) {
        this.server.injectTaskFailure(traceToken, stageId, partitionId, attemptId, injectionType, errorType);
    }

    @Override
    public void loadExchangeManager(String name, Map<String, String> properties) {
        this.server.loadExchangeManager(name, properties);
    }
}

