/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsAssertion;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingSession;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Test;

public class TestFilterProjectAggregationStatsRule
extends BaseStatsCalculatorTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final SymbolStatsEstimate SYMBOL_STATS_ESTIMATE_X = SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(100.0).setDistinctValuesCount(10.0).setNullsFraction(0.1).build();
    private static final SymbolStatsEstimate SYMBOL_STATS_ESTIMATE_Y = SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(10.0).setDistinctValuesCount(10.0).setNullsFraction(0.0).build();
    private static final Session APPROXIMATION_ENABLED = TestingSession.testSessionBuilder().setSystemProperty("non_estimatable_predicate_approximation_enabled", "true").build();
    private static final Session APPROXIMATION_DISABLED = TestingSession.testSessionBuilder().setSystemProperty("non_estimatable_predicate_approximation_enabled", "false").build();

    @Test
    public void testFilterOverAggregationStats() {
        Function<PlanBuilder, PlanNode> planProvider = pb -> pb.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "count_on_x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (PlanNode)pb.aggregation(ab -> ab.addAggregation(pb.symbol("count_on_x", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(pb.symbol("y", (Type)BigintType.BIGINT)).source((PlanNode)pb.values(pb.symbol("x", (Type)BigintType.BIGINT), pb.symbol("y", (Type)BigintType.BIGINT)))));
        PlanNodeStatsEstimate sourceStats = PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), SYMBOL_STATS_ESTIMATE_Y).build();
        this.tester().assertStatsFor(APPROXIMATION_ENABLED, planProvider).withSourceStats(sourceStats).check(check -> check.outputRowsCount(90.0).symbolStatsUnknown("count_on_x", (Type)DoubleType.DOUBLE));
        this.tester().assertStatsFor(APPROXIMATION_DISABLED, planProvider).withSourceStats(sourceStats).check(PlanNodeStatsAssertion::outputRowsCountUnknown);
        this.tester().assertStatsFor(APPROXIMATION_ENABLED, planProvider).withSourceStats(PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "y"), SymbolStatsEstimate.builder().setDistinctValuesCount(50.0).build()).build()).check(PlanNodeStatsAssertion::outputRowsCountUnknown);
        this.tester().assertStatsFor(APPROXIMATION_ENABLED, pb -> pb.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)), (PlanNode)pb.aggregation(ab -> ab.addAggregation(pb.symbol("count_on_x", (Type)DoubleType.DOUBLE), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "x"))), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE)).singleGroupingSet(pb.symbol("y", (Type)DoubleType.DOUBLE)).source((PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))))).withSourceStats(sourceStats).check(check -> check.outputRowsCount(10.0));
    }

    @Test
    public void testFilterAndProjectOverAggregationStats() {
        PlanNodeId aggregationId = new PlanNodeId("aggregation");
        PlanNodeStatsEstimate sourceStats = PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "x"), SYMBOL_STATS_ESTIMATE_X).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "y"), SYMBOL_STATS_ESTIMATE_Y).build();
        this.tester().assertStatsFor(APPROXIMATION_ENABLED, pb -> {
            Symbol aggregatedOutput = pb.symbol("count_on_x", (Type)BigintType.BIGINT);
            return pb.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "count_on_x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (PlanNode)pb.project(Assignments.identity((Symbol[])new Symbol[]{aggregatedOutput}), (PlanNode)pb.aggregation(ab -> ab.addAggregation(aggregatedOutput, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(pb.symbol("y", (Type)BigintType.BIGINT)).source((PlanNode)pb.values(pb.symbol("x", (Type)BigintType.BIGINT), pb.symbol("y", (Type)BigintType.BIGINT))).nodeId(aggregationId))));
        }).withSourceStats(sourceStats).withSourceStats(aggregationId, PlanNodeStatsEstimate.builder().setOutputRowCount(50.0).build()).check(check -> check.outputRowsCount(45.0));
        this.tester().assertStatsFor(APPROXIMATION_ENABLED, pb -> {
            Symbol aggregatedOutput = pb.symbol("count_on_x", (Type)BigintType.BIGINT);
            return pb.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "count_on_x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (PlanNode)pb.project(Assignments.of((Symbol)pb.symbol("x_1", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Symbol)aggregatedOutput, (Expression)aggregatedOutput.toSymbolReference()), (PlanNode)pb.aggregation(ab -> ab.addAggregation(aggregatedOutput, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(pb.symbol("y", (Type)BigintType.BIGINT)).source((PlanNode)pb.values(pb.symbol("x", (Type)BigintType.BIGINT), pb.symbol("y", (Type)BigintType.BIGINT))).nodeId(aggregationId))));
        }).withSourceStats(sourceStats).withSourceStats(aggregationId, PlanNodeStatsEstimate.builder().setOutputRowCount(50.0).build()).check(PlanNodeStatsAssertion::outputRowsCountUnknown);
    }
}

