/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestSimpleFilterProjectSemiJoinStatsRule
extends BaseStatsCalculatorTest {
    private SymbolStatsEstimate aStats = SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(10.0).setDistinctValuesCount(10.0).setNullsFraction(0.1).build();
    private SymbolStatsEstimate bStats = SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(100.0).setDistinctValuesCount(10.0).setNullsFraction(0.0).build();
    private SymbolStatsEstimate cStats = SymbolStatsEstimate.builder().setLowValue(5.0).setHighValue(30.0).setDistinctValuesCount(2.0).setNullsFraction(0.5).build();
    private SymbolStatsEstimate expectedAInC = SymbolStatsEstimate.builder().setDistinctValuesCount(2.0).setLowValue(0.0).setHighValue(10.0).setNullsFraction(0.0).build();
    private SymbolStatsEstimate expectedANotInC = SymbolStatsEstimate.builder().setDistinctValuesCount(1.6).setLowValue(0.0).setHighValue(8.0).setNullsFraction(0.0).build();
    private SymbolStatsEstimate expectedANotInCWithExtraFilter = SymbolStatsEstimate.builder().setDistinctValuesCount(8.0).setLowValue(0.0).setHighValue(10.0).setNullsFraction(0.0).build();
    private static final PlanNodeId LEFT_SOURCE_ID = new PlanNodeId("left_source_values");
    private static final PlanNodeId RIGHT_SOURCE_ID = new PlanNodeId("right_source_values");

    @Test
    public void testFilterPositiveSemiJoin() {
        this.tester().assertStatsFor(pb -> {
            Symbol a = pb.symbol("a", (Type)DoubleType.DOUBLE);
            Symbol b = pb.symbol("b", (Type)DoubleType.DOUBLE);
            Symbol c = pb.symbol("c", (Type)DoubleType.DOUBLE);
            Symbol semiJoinOutput = pb.symbol("sjo", (Type)BooleanType.BOOLEAN);
            return pb.filter((Expression)semiJoinOutput.toSymbolReference(), (PlanNode)pb.semiJoin((PlanNode)pb.values(LEFT_SOURCE_ID, a, b), (PlanNode)pb.values(RIGHT_SOURCE_ID, c), a, c, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty()));
        }).withSourceStats(LEFT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "a"), this.aStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "b"), this.bStats).build()).withSourceStats(RIGHT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "c"), this.cStats).build()).check(check -> check.outputRowsCount(180.0).symbolStats("a", assertion -> assertion.isEqualTo(this.expectedAInC)).symbolStats("b", assertion -> assertion.isEqualTo(this.bStats)).symbolStatsUnknown("c", (Type)DoubleType.DOUBLE).symbolStatsUnknown("sjo", (Type)BooleanType.BOOLEAN));
    }

    @Test
    public void testFilterPositiveNarrowingProjectSemiJoin() {
        this.tester().assertStatsFor(pb -> {
            Symbol a = pb.symbol("a", (Type)DoubleType.DOUBLE);
            Symbol b = pb.symbol("b", (Type)DoubleType.DOUBLE);
            Symbol c = pb.symbol("c", (Type)DoubleType.DOUBLE);
            Symbol semiJoinOutput = pb.symbol("sjo", (Type)BooleanType.BOOLEAN);
            return pb.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "sjo"), (PlanNode)pb.project(Assignments.identity((Symbol[])new Symbol[]{semiJoinOutput, a}), (PlanNode)pb.semiJoin((PlanNode)pb.values(LEFT_SOURCE_ID, a, b), (PlanNode)pb.values(RIGHT_SOURCE_ID, c), a, c, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty())));
        }).withSourceStats(LEFT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "a"), this.aStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "b"), this.bStats).build()).withSourceStats(RIGHT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "c"), this.cStats).build()).check(check -> check.outputRowsCount(180.0).symbolStats("a", assertion -> assertion.isEqualTo(this.expectedAInC)).symbolStatsUnknown("b", (Type)DoubleType.DOUBLE).symbolStatsUnknown("c", (Type)DoubleType.DOUBLE).symbolStatsUnknown("sjo", (Type)DoubleType.DOUBLE));
    }

    @Test
    public void testFilterPositivePlusExtraConjunctSemiJoin() {
        this.tester().assertStatsFor(pb -> {
            Symbol a = pb.symbol("a", (Type)DoubleType.DOUBLE);
            Symbol b = pb.symbol("b", (Type)DoubleType.DOUBLE);
            Symbol c = pb.symbol("c", (Type)DoubleType.DOUBLE);
            Symbol semiJoinOutput = pb.symbol("sjo", (Type)BooleanType.BOOLEAN);
            return pb.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "sjo"), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "a"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)8.0)))), (PlanNode)pb.semiJoin((PlanNode)pb.values(LEFT_SOURCE_ID, a, b), (PlanNode)pb.values(RIGHT_SOURCE_ID, c), a, c, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty()));
        }).withSourceStats(LEFT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "a"), this.aStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "b"), this.bStats).build()).withSourceStats(RIGHT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "c"), this.cStats).build()).check(check -> check.outputRowsCount(144.0).symbolStats("a", assertion -> assertion.isEqualTo(this.expectedANotInC)).symbolStats("b", assertion -> assertion.isEqualTo(this.bStats)).symbolStatsUnknown("c", (Type)DoubleType.DOUBLE).symbolStatsUnknown("sjo", (Type)BooleanType.BOOLEAN));
    }

    @Test
    public void testFilterNegativeSemiJoin() {
        this.tester().assertStatsFor(pb -> {
            Symbol a = pb.symbol("a", (Type)DoubleType.DOUBLE);
            Symbol b = pb.symbol("b", (Type)DoubleType.DOUBLE);
            Symbol c = pb.symbol("c", (Type)DoubleType.DOUBLE);
            Symbol semiJoinOutput = pb.symbol("sjo", (Type)BooleanType.BOOLEAN);
            return pb.filter((Expression)new Not((Expression)new Reference((Type)BooleanType.BOOLEAN, "sjo")), (PlanNode)pb.semiJoin((PlanNode)pb.values(LEFT_SOURCE_ID, a, b), (PlanNode)pb.values(RIGHT_SOURCE_ID, c), a, c, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty()));
        }).withSourceStats(LEFT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "a"), this.aStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "b"), this.bStats).build()).withSourceStats(RIGHT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "c"), this.cStats).build()).check(check -> check.outputRowsCount(720.0).symbolStats("a", assertion -> assertion.isEqualTo(this.expectedANotInCWithExtraFilter)).symbolStats("b", assertion -> assertion.isEqualTo(this.bStats)).symbolStatsUnknown("c", (Type)DoubleType.DOUBLE).symbolStatsUnknown("sjo", (Type)BooleanType.BOOLEAN));
    }
}

