/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.timesharing;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.trino.execution.SplitRunner;
import io.trino.execution.executor.timesharing.SimulationTask;
import io.trino.operator.Operator;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

abstract class SimulationSplit
implements SplitRunner {
    private final SimulationTask task;
    private final AtomicInteger calls = new AtomicInteger(0);
    private final AtomicLong completedProcessNanos = new AtomicLong();
    private final AtomicLong startNanos = new AtomicLong(-1L);
    private final AtomicLong doneNanos = new AtomicLong(-1L);
    private final AtomicLong waitNanos = new AtomicLong();
    private final AtomicLong lastReadyTime = new AtomicLong(-1L);
    private final AtomicBoolean killed = new AtomicBoolean(false);
    private final long scheduledTimeNanos;

    SimulationSplit(SimulationTask task, long scheduledTimeNanos) {
        this.task = Objects.requireNonNull(task, "task is null");
        this.scheduledTimeNanos = scheduledTimeNanos;
    }

    long getCompletedProcessNanos() {
        return this.completedProcessNanos.get();
    }

    long getWaitNanos() {
        return this.waitNanos.get();
    }

    int getCalls() {
        return this.calls.get();
    }

    long getScheduledTimeNanos() {
        return this.scheduledTimeNanos;
    }

    boolean isKilled() {
        return this.killed.get();
    }

    void setKilled() {
        this.waitNanos.addAndGet(System.nanoTime() - this.lastReadyTime.get());
        this.killed.set(true);
    }

    public int getPipelineId() {
        return 0;
    }

    public Span getPipelineSpan() {
        return Span.getInvalid();
    }

    public boolean isFinished() {
        return this.doneNanos.get() >= 0L;
    }

    public void close() {
    }

    abstract boolean process();

    abstract ListenableFuture<Void> getProcessResult();

    void setSplitReady() {
        this.lastReadyTime.set(System.nanoTime());
    }

    public ListenableFuture<Void> processFor(Duration duration) {
        this.calls.incrementAndGet();
        long callStart = System.nanoTime();
        this.startNanos.compareAndSet(-1L, callStart);
        this.lastReadyTime.compareAndSet(-1L, callStart);
        this.waitNanos.addAndGet(callStart - this.lastReadyTime.get());
        boolean done = this.process();
        long callEnd = System.nanoTime();
        this.completedProcessNanos.addAndGet(callEnd - callStart);
        if (done) {
            this.doneNanos.compareAndSet(-1L, callEnd);
            if (!this.isKilled()) {
                this.task.splitComplete(this);
            }
            return Futures.immediateVoidFuture();
        }
        ListenableFuture<Void> processResult = this.getProcessResult();
        if (processResult.isDone()) {
            this.setSplitReady();
        }
        return processResult;
    }

    static class IntermediateSplit
    extends SimulationSplit {
        private final long wallTimeNanos;
        private final long numQuantas;
        private final long perQuantaNanos;
        private final long betweenQuantaNanos;
        private final ScheduledExecutorService executorService;
        private SettableFuture<Void> future = SettableFuture.create();
        private final SettableFuture<Void> doneFuture = SettableFuture.create();

        public IntermediateSplit(SimulationTask task, long scheduledTimeNanos, long wallTimeNanos, long numQuantas, long perQuantaNanos, long betweenQuantaNanos, ScheduledExecutorService executorService) {
            super(task, scheduledTimeNanos);
            this.wallTimeNanos = wallTimeNanos;
            this.numQuantas = numQuantas;
            this.perQuantaNanos = perQuantaNanos;
            this.betweenQuantaNanos = betweenQuantaNanos;
            this.executorService = executorService;
            this.doneFuture.set(null);
        }

        @Override
        public boolean process() {
            try {
                if ((long)this.getCalls() < this.numQuantas) {
                    TimeUnit.NANOSECONDS.sleep(this.perQuantaNanos);
                    return false;
                }
            }
            catch (InterruptedException ignored) {
                this.setKilled();
                return true;
            }
            return true;
        }

        @Override
        public ListenableFuture<Void> getProcessResult() {
            this.future = SettableFuture.create();
            try {
                this.executorService.schedule(() -> {
                    try {
                        if (!this.executorService.isShutdown()) {
                            this.future.set(null);
                        } else {
                            this.setKilled();
                        }
                        this.setSplitReady();
                    }
                    catch (RuntimeException ignored) {
                        this.setKilled();
                    }
                }, this.betweenQuantaNanos, TimeUnit.NANOSECONDS);
            }
            catch (RejectedExecutionException ignored) {
                this.setKilled();
                return this.doneFuture;
            }
            return this.future;
        }

        public String getInfo() {
            double pct = 100.0 * (double)this.getCalls() / (double)this.numQuantas;
            return String.format("intr %3s%% done (wall: %9s, per quanta: %8s, between quanta: %8s)", (int)(pct > 100.0 ? 100.0 : pct), Duration.succinctNanos((long)this.wallTimeNanos), Duration.succinctNanos((long)this.perQuantaNanos), Duration.succinctNanos((long)this.betweenQuantaNanos));
        }
    }

    static class LeafSplit
    extends SimulationSplit {
        private final long perQuantaNanos;

        public LeafSplit(SimulationTask task, long scheduledTimeNanos, long perQuantaNanos) {
            super(task, scheduledTimeNanos);
            this.perQuantaNanos = perQuantaNanos;
        }

        @Override
        public boolean process() {
            if (this.getCompletedProcessNanos() >= this.scheduledTimeNanos) {
                return true;
            }
            long processNanos = Math.min(this.scheduledTimeNanos - this.getCompletedProcessNanos(), this.perQuantaNanos);
            if (processNanos > 0L) {
                try {
                    TimeUnit.NANOSECONDS.sleep(processNanos);
                }
                catch (InterruptedException e) {
                    this.setKilled();
                    return true;
                }
            }
            return false;
        }

        @Override
        public ListenableFuture<Void> getProcessResult() {
            return Operator.NOT_BLOCKED;
        }

        public String getInfo() {
            double pct = 100.0 * (double)this.getCompletedProcessNanos() / (double)this.scheduledTimeNanos;
            return String.format("leaf %3s%% done (total: %8s, per quanta: %8s)", (int)(pct > 100.0 ? 100.0 : pct), Duration.succinctNanos((long)this.scheduledTimeNanos), Duration.succinctNanos((long)this.perQuantaNanos));
        }
    }
}

