/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.operator.OperatorInfo;
import io.trino.operator.OperatorStats;
import io.trino.operator.SplitOperatorInfo;
import io.trino.operator.output.PartitionedOutputOperator;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.spi.metrics.Metrics;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOperatorStats {
    private static final SplitOperatorInfo NON_MERGEABLE_INFO = new SplitOperatorInfo(TestingHandles.TEST_CATALOG_HANDLE, Map.of("some_info", "some_value"));
    private static final PartitionedOutputOperator.PartitionedOutputInfo MERGEABLE_INFO = new PartitionedOutputOperator.PartitionedOutputInfo(1024L);
    public static final OperatorStats EXPECTED = new OperatorStats(0, 1, 41, new PlanNodeId("test"), "test", 1L, 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)51L), 511L, new Duration(5.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)52L), 522L, DataSize.ofBytes((long)5L), DataSize.ofBytes((long)6L), 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)12L), 13L, 533L, new Metrics((Map)ImmutableMap.of((Object)"metrics", (Object)new LongCount(42L))), new Metrics((Map)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(43L))), DataSize.ofBytes((long)14L), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)19L), DataSize.ofBytes((long)20L), DataSize.ofBytes((long)22L), DataSize.ofBytes((long)24L), DataSize.ofBytes((long)25L), DataSize.ofBytes((long)26L), Optional.empty(), (OperatorInfo)NON_MERGEABLE_INFO);
    public static final OperatorStats MERGEABLE = new OperatorStats(0, 1, 41, new PlanNodeId("test"), "test", 1L, 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)51L), 511L, new Duration(5.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)52L), 522L, DataSize.ofBytes((long)5L), DataSize.ofBytes((long)6L), 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)12L), 13L, 533L, new Metrics((Map)ImmutableMap.of((Object)"metrics", (Object)new LongCount(42L))), new Metrics((Map)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(43L))), DataSize.ofBytes((long)14L), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)19L), DataSize.ofBytes((long)20L), DataSize.ofBytes((long)22L), DataSize.ofBytes((long)24L), DataSize.ofBytes((long)25L), DataSize.ofBytes((long)26L), Optional.empty(), (OperatorInfo)MERGEABLE_INFO);

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(OperatorStats.class);
        String json = codec.toJson((Object)EXPECTED);
        OperatorStats actual = (OperatorStats)codec.fromJson(json);
        TestOperatorStats.assertExpectedOperatorStats(actual);
    }

    public static void assertExpectedOperatorStats(OperatorStats actual) {
        Assertions.assertThat((int)actual.getStageId()).isEqualTo(0);
        Assertions.assertThat((int)actual.getOperatorId()).isEqualTo(41);
        Assertions.assertThat((String)actual.getOperatorType()).isEqualTo("test");
        Assertions.assertThat((long)actual.getTotalDrivers()).isEqualTo(1L);
        Assertions.assertThat((long)actual.getAddInputCalls()).isEqualTo(2L);
        Assertions.assertThat((Comparable)actual.getAddInputWall()).isEqualTo((Object)new Duration(3.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getAddInputCpu()).isEqualTo((Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)51L));
        Assertions.assertThat((long)actual.getPhysicalInputPositions()).isEqualTo(511L);
        Assertions.assertThat((Comparable)actual.getPhysicalInputReadTime()).isEqualTo((Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)52L));
        Assertions.assertThat((long)actual.getInternalNetworkInputPositions()).isEqualTo(522L);
        Assertions.assertThat((Comparable)actual.getRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)5L));
        Assertions.assertThat((Comparable)actual.getInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)6L));
        Assertions.assertThat((long)actual.getInputPositions()).isEqualTo(7L);
        Assertions.assertThat((double)actual.getSumSquaredInputPositions()).isEqualTo(8.0);
        Assertions.assertThat((long)actual.getGetOutputCalls()).isEqualTo(9L);
        Assertions.assertThat((Comparable)actual.getGetOutputWall()).isEqualTo((Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getGetOutputCpu()).isEqualTo((Object)new Duration(11.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)12L));
        Assertions.assertThat((long)actual.getOutputPositions()).isEqualTo(13L);
        Assertions.assertThat((long)actual.getDynamicFilterSplitsProcessed()).isEqualTo(533L);
        Assertions.assertThat((Map)actual.getMetrics().getMetrics()).isEqualTo((Object)ImmutableMap.of((Object)"metrics", (Object)new LongCount(42L)));
        Assertions.assertThat((Map)actual.getConnectorMetrics().getMetrics()).isEqualTo((Object)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(43L)));
        Assertions.assertThat((Comparable)actual.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)14L));
        Assertions.assertThat((Comparable)actual.getBlockedWall()).isEqualTo((Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((long)actual.getFinishCalls()).isEqualTo(16L);
        Assertions.assertThat((Comparable)actual.getFinishWall()).isEqualTo((Object)new Duration(17.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFinishCpu()).isEqualTo((Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)19L));
        Assertions.assertThat((Comparable)actual.getRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)20L));
        Assertions.assertThat((Comparable)actual.getPeakUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)22L));
        Assertions.assertThat((Comparable)actual.getPeakRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)24L));
        Assertions.assertThat((Comparable)actual.getPeakTotalMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)25L));
        Assertions.assertThat((Comparable)actual.getSpilledDataSize()).isEqualTo((Object)DataSize.ofBytes((long)26L));
        Assertions.assertThat((Class)actual.getInfo().getClass()).isEqualTo(SplitOperatorInfo.class);
        Assertions.assertThat((Map)((SplitOperatorInfo)actual.getInfo()).getSplitInfo()).isEqualTo((Object)NON_MERGEABLE_INFO.getSplitInfo());
    }

    @Test
    public void testAdd() {
        OperatorStats actual = EXPECTED.add((Iterable)ImmutableList.of((Object)EXPECTED, (Object)EXPECTED));
        Assertions.assertThat((int)actual.getStageId()).isEqualTo(0);
        Assertions.assertThat((int)actual.getOperatorId()).isEqualTo(41);
        Assertions.assertThat((String)actual.getOperatorType()).isEqualTo("test");
        Assertions.assertThat((long)actual.getTotalDrivers()).isEqualTo(3L);
        Assertions.assertThat((long)actual.getAddInputCalls()).isEqualTo(6L);
        Assertions.assertThat((Comparable)actual.getAddInputWall()).isEqualTo((Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getAddInputCpu()).isEqualTo((Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)153L));
        Assertions.assertThat((long)actual.getPhysicalInputPositions()).isEqualTo(1533L);
        Assertions.assertThat((Comparable)actual.getPhysicalInputReadTime()).isEqualTo((Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)156L));
        Assertions.assertThat((long)actual.getInternalNetworkInputPositions()).isEqualTo(1566L);
        Assertions.assertThat((Comparable)actual.getRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)15L));
        Assertions.assertThat((Comparable)actual.getInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)18L));
        Assertions.assertThat((long)actual.getInputPositions()).isEqualTo(21L);
        Assertions.assertThat((double)actual.getSumSquaredInputPositions()).isEqualTo(24.0);
        Assertions.assertThat((long)actual.getGetOutputCalls()).isEqualTo(27L);
        Assertions.assertThat((Comparable)actual.getGetOutputWall()).isEqualTo((Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getGetOutputCpu()).isEqualTo((Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)36L));
        Assertions.assertThat((long)actual.getOutputPositions()).isEqualTo(39L);
        Assertions.assertThat((long)actual.getDynamicFilterSplitsProcessed()).isEqualTo(1599L);
        Assertions.assertThat((Map)actual.getMetrics().getMetrics()).isEqualTo((Object)ImmutableMap.of((Object)"metrics", (Object)new LongCount(126L)));
        Assertions.assertThat((Map)actual.getConnectorMetrics().getMetrics()).isEqualTo((Object)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(129L)));
        Assertions.assertThat((Comparable)actual.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)42L));
        Assertions.assertThat((Comparable)actual.getBlockedWall()).isEqualTo((Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((long)actual.getFinishCalls()).isEqualTo(48L);
        Assertions.assertThat((Comparable)actual.getFinishWall()).isEqualTo((Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFinishCpu()).isEqualTo((Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)57L));
        Assertions.assertThat((Comparable)actual.getRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)60L));
        Assertions.assertThat((Comparable)actual.getPeakUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)22L));
        Assertions.assertThat((Comparable)actual.getPeakRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)24L));
        Assertions.assertThat((Comparable)actual.getPeakTotalMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)25L));
        Assertions.assertThat((Comparable)actual.getSpilledDataSize()).isEqualTo((Object)DataSize.ofBytes((long)78L));
        Assertions.assertThat((Object)actual.getInfo()).isNull();
    }

    @Test
    public void testAddMergeable() {
        OperatorStats actual = MERGEABLE.add((Iterable)ImmutableList.of((Object)MERGEABLE, (Object)MERGEABLE));
        Assertions.assertThat((int)actual.getStageId()).isEqualTo(0);
        Assertions.assertThat((int)actual.getOperatorId()).isEqualTo(41);
        Assertions.assertThat((String)actual.getOperatorType()).isEqualTo("test");
        Assertions.assertThat((long)actual.getTotalDrivers()).isEqualTo(3L);
        Assertions.assertThat((long)actual.getAddInputCalls()).isEqualTo(6L);
        Assertions.assertThat((Comparable)actual.getAddInputWall()).isEqualTo((Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getAddInputCpu()).isEqualTo((Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)153L));
        Assertions.assertThat((long)actual.getPhysicalInputPositions()).isEqualTo(1533L);
        Assertions.assertThat((Comparable)actual.getPhysicalInputReadTime()).isEqualTo((Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)156L));
        Assertions.assertThat((long)actual.getInternalNetworkInputPositions()).isEqualTo(1566L);
        Assertions.assertThat((Comparable)actual.getRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)15L));
        Assertions.assertThat((Comparable)actual.getInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)18L));
        Assertions.assertThat((long)actual.getInputPositions()).isEqualTo(21L);
        Assertions.assertThat((double)actual.getSumSquaredInputPositions()).isEqualTo(24.0);
        Assertions.assertThat((long)actual.getGetOutputCalls()).isEqualTo(27L);
        Assertions.assertThat((Comparable)actual.getGetOutputWall()).isEqualTo((Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getGetOutputCpu()).isEqualTo((Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)36L));
        Assertions.assertThat((long)actual.getOutputPositions()).isEqualTo(39L);
        Assertions.assertThat((long)actual.getDynamicFilterSplitsProcessed()).isEqualTo(1599L);
        Assertions.assertThat((Map)actual.getMetrics().getMetrics()).isEqualTo((Object)ImmutableMap.of((Object)"metrics", (Object)new LongCount(126L)));
        Assertions.assertThat((Map)actual.getConnectorMetrics().getMetrics()).isEqualTo((Object)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(129L)));
        Assertions.assertThat((Comparable)actual.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)42L));
        Assertions.assertThat((Comparable)actual.getBlockedWall()).isEqualTo((Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((long)actual.getFinishCalls()).isEqualTo(48L);
        Assertions.assertThat((Comparable)actual.getFinishWall()).isEqualTo((Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFinishCpu()).isEqualTo((Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)57L));
        Assertions.assertThat((Comparable)actual.getRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)60L));
        Assertions.assertThat((Comparable)actual.getPeakUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)22L));
        Assertions.assertThat((Comparable)actual.getPeakRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)24L));
        Assertions.assertThat((Comparable)actual.getPeakTotalMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)25L));
        Assertions.assertThat((Comparable)actual.getSpilledDataSize()).isEqualTo((Object)DataSize.ofBytes((long)78L));
        Assertions.assertThat((Class)actual.getInfo().getClass()).isEqualTo(PartitionedOutputOperator.PartitionedOutputInfo.class);
        Assertions.assertThat((long)((PartitionedOutputOperator.PartitionedOutputInfo)actual.getInfo()).getOutputBufferPeakMemoryUsage()).isEqualTo(MERGEABLE_INFO.getOutputBufferPeakMemoryUsage());
    }
}

