/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.arrayagg;

import io.trino.operator.PagesIndex;
import io.trino.operator.aggregation.arrayagg.FlatArrayBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Optional;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFlatArrayBuilder {
    private final MethodHandle valueReadFlat = PagesIndex.TestingFactory.TYPE_OPERATORS.getReadValueOperator((Type)BigintType.BIGINT, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
    private final MethodHandle valueWriteFlat = PagesIndex.TestingFactory.TYPE_OPERATORS.getReadValueOperator((Type)BigintType.BIGINT, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}));

    @Test
    public void testWriteAll() {
        int size = 1024;
        FlatArrayBuilder flatArrayBuilder = new FlatArrayBuilder((Type)BigintType.BIGINT, this.valueReadFlat, this.valueWriteFlat, false);
        LongArrayBlock valueBlock = new LongArrayBlock(size, Optional.empty(), IntStream.range(0, size).mapToLong(i -> i).toArray());
        for (int i2 = 0; i2 < size; ++i2) {
            flatArrayBuilder.add((ValueBlock)valueBlock, i2);
        }
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, size);
        flatArrayBuilder.writeAll((BlockBuilder)blockBuilder);
        Block block = blockBuilder.build();
        Assertions.assertEquals((int)size, (int)block.getPositionCount());
        for (int i3 = 0; i3 < size; ++i3) {
            Assertions.assertEquals((long)i3, (long)BigintType.BIGINT.getLong(block, i3));
        }
    }

    @Test
    public void testWrite() {
        int size = 1024;
        FlatArrayBuilder flatArrayBuilder = new FlatArrayBuilder((Type)BigintType.BIGINT, this.valueReadFlat, this.valueWriteFlat, true);
        LongArrayBlock valueBlock = new LongArrayBlock(size, Optional.empty(), IntStream.range(0, size).mapToLong(i -> i).toArray());
        for (int i2 = 0; i2 < size; ++i2) {
            flatArrayBuilder.add((ValueBlock)valueBlock, i2);
            if (i2 == size - 1) continue;
            flatArrayBuilder.setNextIndex((long)i2, (long)(i2 + 1));
        }
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, size);
        long nextIndex = 0L;
        while (nextIndex != -1L) {
            nextIndex = flatArrayBuilder.write(nextIndex, (BlockBuilder)blockBuilder);
        }
        Block block = blockBuilder.build();
        Assertions.assertEquals((int)size, (int)block.getPositionCount());
        for (int i3 = 0; i3 < size; ++i3) {
            Assertions.assertEquals((long)i3, (long)BigintType.BIGINT.getLong(block, i3));
        }
    }
}

