/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.junit.jupiter.api.Test;

public class TestDoubleMinNAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createLongRepeatBlock(2, length)};
    }

    @Override
    protected String getFunctionName() {
        return "min";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return ImmutableList.of((Object)start);
        }
        return ImmutableList.of((Object)start, (Object)((double)start + 1.0));
    }

    @Test
    public void testMoreCornerCases() {
        this.testCustomAggregation(new Double[]{1.0, 2.0, null, 3.0}, 5);
        this.testInvalidAggregation(new Double[]{1.0, 2.0, 3.0}, 0);
        this.testInvalidAggregation(new Double[]{1.0, 2.0, 3.0}, -1);
    }

    private void testInvalidAggregation(Double[] x, int n) {
        this.assertInvalidAggregation(() -> this.testAggregation(new long[0], new Block[]{BlockAssertions.createDoublesBlock(x), BlockAssertions.createLongRepeatBlock(n, x.length)}));
    }

    private void testCustomAggregation(Double[] values, int n) {
        PriorityQueue heap = new PriorityQueue(n, (x, y) -> -Double.compare(x, y));
        Arrays.stream(values).filter(Objects::nonNull).forEach(heap::add);
        Double[] expected = new Double[heap.size()];
        for (int i = heap.size() - 1; i >= 0; --i) {
            expected[i] = (Double)heap.remove();
        }
        this.testAggregation(Arrays.asList(expected), new Block[]{BlockAssertions.createDoublesBlock(values), BlockAssertions.createLongRepeatBlock(n, values.length)});
    }
}

