/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.JsonExtract;
import io.trino.operator.scalar.JsonPathTokenizer;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJsonExtract {
    @Test
    public void testJsonTokenizer() {
        Assertions.assertThat(TestJsonExtract.tokenizePath("$")).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat(TestJsonExtract.tokenizePath("$")).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.foo")).isEqualTo((Object)ImmutableList.of((Object)"foo"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$[\"foo\"]")).isEqualTo((Object)ImmutableList.of((Object)"foo"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$[\"foo.bar\"]")).isEqualTo((Object)ImmutableList.of((Object)"foo.bar"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$[42]")).isEqualTo((Object)ImmutableList.of((Object)"42"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.42")).isEqualTo((Object)ImmutableList.of((Object)"42"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.42.63")).isEqualTo((Object)ImmutableList.of((Object)"42", (Object)"63"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.foo.42.bar.63")).isEqualTo((Object)ImmutableList.of((Object)"foo", (Object)"42", (Object)"bar", (Object)"63"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.x.foo")).isEqualTo((Object)ImmutableList.of((Object)"x", (Object)"foo"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.x[\"foo\"]")).isEqualTo((Object)ImmutableList.of((Object)"x", (Object)"foo"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.x[42]")).isEqualTo((Object)ImmutableList.of((Object)"x", (Object)"42"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.foo_42._bar63")).isEqualTo((Object)ImmutableList.of((Object)"foo_42", (Object)"_bar63"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$[foo_42][_bar63]")).isEqualTo((Object)ImmutableList.of((Object)"foo_42", (Object)"_bar63"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.foo:42.:bar63")).isEqualTo((Object)ImmutableList.of((Object)"foo:42", (Object)":bar63"));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$[\"foo:42\"][\":bar63\"]")).isEqualTo((Object)ImmutableList.of((Object)"foo:42", (Object)":bar63"));
        TestJsonExtract.assertPathToken("foo");
        TestJsonExtract.assertQuotedPathToken("-1.1");
        TestJsonExtract.assertQuotedPathToken("!@#$%^&*()[]{}/?'");
        TestJsonExtract.assertQuotedPathToken("ab\u0001c");
        TestJsonExtract.assertQuotedPathToken("ab\u0000c");
        TestJsonExtract.assertQuotedPathToken("ab\t\n\rc");
        TestJsonExtract.assertQuotedPathToken(".");
        TestJsonExtract.assertQuotedPathToken("$");
        TestJsonExtract.assertQuotedPathToken("]");
        TestJsonExtract.assertQuotedPathToken("[");
        TestJsonExtract.assertQuotedPathToken("'");
        TestJsonExtract.assertQuotedPathToken("!@#$%^&*(){}[]<>?/|.,`~\r\n\t \u0000");
        TestJsonExtract.assertQuotedPathToken("a\\\\b\\\"", "a\\b\"");
        TestJsonExtract.assertInvalidPath("$[\"a\\ \"]");
        TestJsonExtract.assertInvalidPath("$[foo:bar]");
        TestJsonExtract.assertInvalidPath(" $.x");
        TestJsonExtract.assertInvalidPath(" $.x ");
        TestJsonExtract.assertInvalidPath("$. x");
        TestJsonExtract.assertInvalidPath("$ .x");
        TestJsonExtract.assertInvalidPath("$\n.x");
        TestJsonExtract.assertInvalidPath("$.x [42]");
        TestJsonExtract.assertInvalidPath("$.x[ 42]");
        TestJsonExtract.assertInvalidPath("$.x[42 ]");
        TestJsonExtract.assertInvalidPath("$.x[ \"foo\"]");
        TestJsonExtract.assertInvalidPath("$.x[\"foo\" ]");
    }

    private static void assertPathToken(String fieldName) {
        Assertions.assertThat((fieldName.indexOf(34) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat(TestJsonExtract.tokenizePath("$." + fieldName)).isEqualTo((Object)ImmutableList.of((Object)fieldName));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.foo." + fieldName + ".bar")).isEqualTo((Object)ImmutableList.of((Object)"foo", (Object)fieldName, (Object)"bar"));
        TestJsonExtract.assertPathTokenQuoting(fieldName);
    }

    private static void assertQuotedPathToken(String fieldName) {
        TestJsonExtract.assertQuotedPathToken(fieldName, fieldName);
    }

    private static void assertQuotedPathToken(String fieldName, String expectedTokenizedField) {
        TestJsonExtract.assertPathTokenQuoting(fieldName, expectedTokenizedField);
        TestJsonExtract.assertInvalidPath("$." + fieldName);
    }

    private static void assertPathTokenQuoting(String fieldName) {
        TestJsonExtract.assertPathTokenQuoting(fieldName, fieldName);
    }

    private static void assertPathTokenQuoting(String fieldName, String expectedTokenizedField) {
        Assertions.assertThat(TestJsonExtract.tokenizePath("$[\"" + fieldName + "\"]")).isEqualTo((Object)ImmutableList.of((Object)expectedTokenizedField));
        Assertions.assertThat(TestJsonExtract.tokenizePath("$.foo[\"" + fieldName + "\"].bar")).isEqualTo((Object)ImmutableList.of((Object)"foo", (Object)expectedTokenizedField, (Object)"bar"));
    }

    public static void assertInvalidPath(String path) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestJsonExtract.tokenizePath(path)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testScalarValueJsonExtractor() throws Exception {
        JsonExtract.ScalarValueJsonExtractor extractor = new JsonExtract.ScalarValueJsonExtractor();
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "123")).isEqualTo("123");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "-1")).isEqualTo("-1");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "0.01")).isEqualTo("0.01");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"abc\"")).isEqualTo("abc");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"\"")).isEqualTo("");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "null")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"ab\\u0001c\"")).isEqualTo("ab\u0001c");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"ab\\u0002c\"")).isEqualTo("ab\u0002c");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "[1, 2, 3]")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": 1}")).isEqualTo(null);
    }

    @Test
    public void testJsonValueJsonExtractor() throws Exception {
        JsonExtract.JsonValueJsonExtractor extractor = new JsonExtract.JsonValueJsonExtractor();
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "123")).isEqualTo("123");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "-1")).isEqualTo("-1");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "0.01")).isEqualTo("0.01");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"abc\"")).isEqualTo("\"abc\"");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"\"")).isEqualTo("\"\"");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "null")).isEqualTo("null");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"ab\\u0001c\"")).isEqualTo("\"ab\\u0001c\"");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"ab\\u0002c\"")).isEqualTo("\"ab\\u0002c\"");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "[1, 2, 3]")).isEqualTo("[1,2,3]");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": 1}")).isEqualTo("{\"a\":1}");
    }

    @Test
    public void testArrayElementJsonExtractor() throws Exception {
        JsonExtract.ObjectFieldJsonExtractor firstExtractor = new JsonExtract.ObjectFieldJsonExtractor("0", (JsonExtract.JsonExtractor)new JsonExtract.ScalarValueJsonExtractor());
        JsonExtract.ObjectFieldJsonExtractor secondExtractor = new JsonExtract.ObjectFieldJsonExtractor("1", (JsonExtract.JsonExtractor)new JsonExtract.ScalarValueJsonExtractor());
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)firstExtractor, "[]")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)firstExtractor, "[1, 2, 3]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)secondExtractor, "[1, 2]")).isEqualTo("2");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)secondExtractor, "[1, null]")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)secondExtractor, "[1]")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)secondExtractor, "[{\"a\": 1}, 2, 3]")).isEqualTo("2");
    }

    @Test
    public void testObjectFieldJsonExtractor() throws Exception {
        JsonExtract.ObjectFieldJsonExtractor extractor = new JsonExtract.ObjectFieldJsonExtractor("fuu", (JsonExtract.JsonExtractor)new JsonExtract.ScalarValueJsonExtractor());
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{}")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": 1}")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"fuu\": 1}")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": 0, \"fuu\": 1}")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": [1, 2, 3], \"fuu\": 1}")).isEqualTo("1");
    }

    @Test
    public void testFullScalarExtract() {
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{}", "$")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": {\"bar\": 1}}", "$.fuu")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1}", "$.fuu")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1}", "$[fuu]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1}", "$[\"fuu\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": null}", "$.fuu")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1}", "$.bar")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": [\"\\u0001\"]}", "$.fuu[0]")).isEqualTo("\u0001");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1, \"bar\": \"abc\"}", "$.bar")).isEqualTo("abc");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": [0.1, 1, 2]}", "$.fuu[0]")).isEqualTo("0.1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": [0, [100, 101], 2]}", "$.fuu[1]")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": [0, [100, 101], 2]}", "$.fuu[1][1]")).isEqualTo("101");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"fuu\": [0, {\"bar\": {\"key\" : [\"value\"]}}, 2]}", "$.fuu[1].bar.key[0]")).isEqualTo("value");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("[0, 1, 2]", "$[0]")).isEqualTo("0");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("\"abc\"", "$")).isEqualTo("abc");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("123", "$")).isEqualTo("123");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("null", "$")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("[0, 1, 2]", "$.1")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("[0, 1, 2]", "$[1]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("[0, 1, 2]", "$[\"1\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$.1")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$[1]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$[\"1\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$.30day")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$[30day]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doScalarExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$[\"30day\"]")).isEqualTo("1");
    }

    @Test
    public void testFullJsonExtract() {
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{}", "$")).isEqualTo("{}");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$.fuu")).isEqualTo("{\"bar\":1}");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$.fuu")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$[fuu]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$[\"fuu\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": null}", "$.fuu")).isEqualTo("null");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$.bar")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [\"\\u0001\"]}", "$.fuu[0]")).isEqualTo("\"\\u0001\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1, \"bar\": \"abc\"}", "$.bar")).isEqualTo("\"abc\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0.1, 1, 2]}", "$.fuu[0]")).isEqualTo("0.1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0, [100, 101], 2]}", "$.fuu[1]")).isEqualTo("[100,101]");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0, [100, 101], 2]}", "$.fuu[1][1]")).isEqualTo("101");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("[0, 1, 2]", "$[0]")).isEqualTo("0");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("\"abc\"", "$")).isEqualTo("\"abc\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("123", "$")).isEqualTo("123");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("null", "$")).isEqualTo("null");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$[\"fuu\"]")).isEqualTo("{\"bar\":1}");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$[\"fuu\"][\"bar\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$[\"fuu\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": null}", "$[\"fuu\"]")).isEqualTo("null");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$[\"bar\"]")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [\"\\u0001\"]}", "$[\"fuu\"][0]")).isEqualTo("\"\\u0001\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1, \"bar\": \"abc\"}", "$[\"bar\"]")).isEqualTo("\"abc\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0.1, 1, 2]}", "$[\"fuu\"][0]")).isEqualTo("0.1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0, [100, 101], 2]}", "$[\"fuu\"][1]")).isEqualTo("[100,101]");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0, [100, 101], 2]}", "$[\"fuu\"][1][1]")).isEqualTo("101");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"@$fuu\": {\".b.ar\": 1}}", "$[\"@$fuu\"]")).isEqualTo("{\".b.ar\":1}");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu..\": 1}", "$[\"fuu..\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fu*u\": null}", "$[\"fu*u\"]")).isEqualTo("null");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\",fuu\": 1}", "$[\"bar\"]")).isEqualTo(null);
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\",fuu\": [\"\\u0001\"]}", "$[\",fuu\"][0]")).isEqualTo("\"\\u0001\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\":fu:u:\": 1, \":b:ar:\": \"abc\"}", "$[\":b:ar:\"]")).isEqualTo("\"abc\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"?()fuu\": [0.1, 1, 2]}", "$[\"?()fuu\"][0]")).isEqualTo("0.1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"f?uu\": [0, [100, 101], 2]}", "$[\"f?uu\"][1]")).isEqualTo("[100,101]");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu()\": [0, [100, 101], 2]}", "$[\"fuu()\"][1][1]")).isEqualTo("101");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$[\"fuu\"].bar")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$.fuu[\"bar\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [\"\\u0001\"]}", "$[\"fuu\"][0]")).isEqualTo("\"\\u0001\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"fuu\": [\"\\u0001\"]}", "$.fuu[0]")).isEqualTo("\"\\u0001\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"@$fuu\": {\"bar\": 1}}", "$[\"@$fuu\"].bar")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\",fuu\": {\"bar\": [\"\\u0001\"]}}", "$[\",fuu\"].bar[0]")).isEqualTo("\"\\u0001\"");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("[0, 1, 2]", "$.1")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("[0, 1, 2]", "$[1]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("[0, 1, 2]", "$[\"1\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$.1")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$[1]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$[\"1\"]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$.30day")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$[30day]")).isEqualTo("1");
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$[\"30day\"]")).isEqualTo("1");
    }

    @Test
    public void testInvalidExtracts() {
        TestJsonExtract.assertInvalidExtract("", "", "Invalid JSON path: ''");
        TestJsonExtract.assertInvalidExtract("{}", "$.bar[2][-1]", "Invalid JSON path: '$.bar[2][-1]'");
        TestJsonExtract.assertInvalidExtract("{}", "$.fuu..bar", "Invalid JSON path: '$.fuu..bar'");
        TestJsonExtract.assertInvalidExtract("{}", "$.", "Invalid JSON path: '$.'");
        TestJsonExtract.assertInvalidExtract("", "$$", "Invalid JSON path: '$$'");
        TestJsonExtract.assertInvalidExtract("", " ", "Invalid JSON path: ' '");
        TestJsonExtract.assertInvalidExtract("", ".", "Invalid JSON path: '.'");
        TestJsonExtract.assertInvalidExtract("{ \"store\": { \"book\": [{ \"title\": \"title\" }] } }", "$.store.book[", "Invalid JSON path: '$.store.book['");
    }

    @Test
    public void testExtractLongString() {
        String longString = "a".repeat(20000001);
        Assertions.assertThat((String)TestJsonExtract.doJsonExtract("{\"key\": \"" + longString + "\"}", "$.key")).isEqualTo("\"" + longString + "\"");
    }

    @Test
    public void testNoAutomaticEncodingDetection() {
        try (QueryAssertions assertions = new QueryAssertions();){
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.function("JSON_EXTRACT_SCALAR", "from_utf8(X'00 00 00 00 7b 22 72 22')", "'$.x'")))).isNull((Type)VarcharType.VARCHAR);
        }
    }

    private static String doExtract(JsonExtract.JsonExtractor<Slice> jsonExtractor, String json) throws IOException {
        JsonFactory jsonFactory = JsonUtils.jsonFactory();
        JsonParser jsonParser = jsonFactory.createParser(json);
        jsonParser.nextToken();
        Slice extract = (Slice)jsonExtractor.extract(jsonParser);
        return extract == null ? null : extract.toStringUtf8();
    }

    private static String doScalarExtract(String inputJson, String jsonPath) {
        Slice value = (Slice)JsonExtract.extract((Slice)Slices.utf8Slice((String)inputJson), (JsonExtract.JsonExtractor)JsonExtract.generateExtractor((String)jsonPath, (JsonExtract.JsonExtractor)new JsonExtract.ScalarValueJsonExtractor()));
        return value == null ? null : value.toStringUtf8();
    }

    private static String doJsonExtract(String inputJson, String jsonPath) {
        Slice value = (Slice)JsonExtract.extract((Slice)Slices.utf8Slice((String)inputJson), (JsonExtract.JsonExtractor)JsonExtract.generateExtractor((String)jsonPath, (JsonExtract.JsonExtractor)new JsonExtract.JsonValueJsonExtractor()));
        return value == null ? null : value.toStringUtf8();
    }

    private static List<String> tokenizePath(String path) {
        return ImmutableList.copyOf((Iterator)new JsonPathTokenizer(path));
    }

    private static void assertInvalidExtract(String inputJson, String jsonPath, String message) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestJsonExtract.doJsonExtract(inputJson, jsonPath)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage(message);
    }
}

